/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.config.TunnelType;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.util.AEColor;
import appeng.capabilities.Capabilities;
import appeng.core.Api;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public final class P2PTunnelRegistry
implements IP2PTunnelRegistry {
    private static final int INITIAL_CAPACITY = 40;
    private final Map<ItemStack, TunnelType> tunnels = new HashMap<ItemStack, TunnelType>(40);
    private final Map<String, TunnelType> modIdTunnels = new HashMap<String, TunnelType>(40);
    private final Map<Capability<?>, TunnelType> capTunnels = new HashMap(40);

    public void configure() {
        IDefinitions definitions = Api.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IParts parts = definitions.parts();
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150478_aa), TunnelType.LIGHT);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150426_aN), TunnelType.LIGHT);
        this.addNewAttunement(blocks.energyCellDense(), TunnelType.FE_POWER);
        this.addNewAttunement(blocks.energyAcceptor(), TunnelType.FE_POWER);
        this.addNewAttunement(blocks.energyCell(), TunnelType.FE_POWER);
        this.addNewAttunement(blocks.energyCellCreative(), TunnelType.FE_POWER);
        this.addNewAttunement(new ItemStack((IItemProvider)Items.field_151137_ax), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((IItemProvider)Items.field_222027_iT), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150379_bu), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_196762_fd), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150453_bW), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150488_af), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150451_bX), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150442_at), TunnelType.REDSTONE);
        this.addNewAttunement(blocks.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.storageBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.importBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.exportBus(), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150438_bZ), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150486_ae), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((IItemProvider)Blocks.field_150447_bR), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((IItemProvider)Items.field_151133_ar), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack((IItemProvider)Items.field_151129_at), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack((IItemProvider)Items.field_151117_aB), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack((IItemProvider)Items.field_151131_as), TunnelType.FLUID);
        for (AEColor c : AEColor.values()) {
            this.addNewAttunement(parts.cableGlass().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableCovered().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableSmart().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableDenseSmart().stack(c, 1), TunnelType.ME);
        }
        this.addNewAttunement(Capabilities.FORGE_ENERGY, TunnelType.FE_POWER);
        this.addNewAttunement(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, TunnelType.FLUID);
        this.addNewAttunement("thermaldynamics", TunnelType.FE_POWER);
        this.addNewAttunement("thermalexpansion", TunnelType.FE_POWER);
        this.addNewAttunement("thermalfoundation", TunnelType.FE_POWER);
        this.addNewAttunement("enderio", TunnelType.FE_POWER);
        this.addNewAttunement("mekanism", TunnelType.FE_POWER);
        this.addNewAttunement("rftools", TunnelType.FE_POWER);
        this.addNewAttunement("ic2", TunnelType.IC2_POWER);
    }

    @Override
    public void addNewAttunement(@Nonnull String modId, @Nullable TunnelType type) {
        if (type == null || modId == null) {
            return;
        }
        this.modIdTunnels.put(modId, type);
    }

    @Override
    public void addNewAttunement(@Nonnull Capability<?> cap, @Nullable TunnelType type) {
        if (type == null || cap == null) {
            return;
        }
        this.capTunnels.put(cap, type);
    }

    @Override
    public void addNewAttunement(@Nonnull ItemStack trigger, @Nullable TunnelType type) {
        if (type == null || trigger.func_190926_b()) {
            return;
        }
        this.tunnels.put(trigger, type);
    }

    @Override
    @Nullable
    public TunnelType getTunnelTypeByItem(ItemStack trigger) {
        if (!trigger.func_190926_b()) {
            for (Map.Entry<ItemStack, TunnelType> entry : this.tunnels.entrySet()) {
                ItemStack is = entry.getKey();
                if (is.func_77973_b() == trigger.func_77973_b()) {
                    return entry.getValue();
                }
                if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)trigger)) continue;
                return entry.getValue();
            }
            for (Direction face : Direction.values()) {
                for (Map.Entry<Capability<?>, TunnelType> entry : this.capTunnels.entrySet()) {
                    if (!trigger.getCapability(entry.getKey(), face).isPresent()) continue;
                    return entry.getValue();
                }
            }
            for (Map.Entry entry : this.modIdTunnels.entrySet()) {
                if (trigger.func_77973_b().getRegistryName() == null || !trigger.func_77973_b().getRegistryName().func_110624_b().equals(entry.getKey())) continue;
                return (TunnelType)((Object)entry.getValue());
            }
        }
        return null;
    }

    @Nonnull
    private ItemStack getModItem(String modID, String name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modID + ":" + name));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack myItemStack = new ItemStack((IItemProvider)item, 1);
        return myItemStack;
    }

    private void addNewAttunement(IItemDefinition definition, TunnelType type) {
        definition.maybeStack(1).ifPresent(definitionStack -> this.addNewAttunement((ItemStack)definitionStack, type));
    }
}

