/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync;

import appeng.core.sync.BasePacket;
import appeng.core.sync.packets.AssemblerAnimationPacket;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.core.sync.packets.ClickPacket;
import appeng.core.sync.packets.CompassRequestPacket;
import appeng.core.sync.packets.CompassResponsePacket;
import appeng.core.sync.packets.ConfigButtonPacket;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.CraftRequestPacket;
import appeng.core.sync.packets.FluidSlotPacket;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.core.sync.packets.ItemTransitionEffectPacket;
import appeng.core.sync.packets.JEIRecipePacket;
import appeng.core.sync.packets.LightningPacket;
import appeng.core.sync.packets.MEFluidInventoryUpdatePacket;
import appeng.core.sync.packets.MEInterfaceUpdatePacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.core.sync.packets.MatterCannonPacket;
import appeng.core.sync.packets.MockExplosionPacket;
import appeng.core.sync.packets.PaintedEntityPacket;
import appeng.core.sync.packets.PartPlacementPacket;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.core.sync.packets.ProgressBarPacket;
import appeng.core.sync.packets.SwapSlotsPacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.core.sync.packets.TargetFluidStackPacket;
import appeng.core.sync.packets.TargetItemStackPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;

public class BasePacketHandler {
    private static final Map<Class<? extends BasePacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends BasePacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_COMPASS_REQUEST(CompassRequestPacket.class, CompassRequestPacket::new),
        PACKET_COMPASS_RESPONSE(CompassResponsePacket.class, CompassResponsePacket::new),
        PACKET_INVENTORY_ACTION(InventoryActionPacket.class, InventoryActionPacket::new),
        PACKET_ME_INVENTORY_UPDATE(MEInventoryUpdatePacket.class, MEInventoryUpdatePacket::new),
        PACKET_ME_FLUID_INVENTORY_UPDATE(MEFluidInventoryUpdatePacket.class, MEFluidInventoryUpdatePacket::new),
        PACKET_CONFIG_BUTTON(ConfigButtonPacket.class, ConfigButtonPacket::new),
        PACKET_PART_PLACEMENT(PartPlacementPacket.class, PartPlacementPacket::new),
        PACKET_LIGHTNING(LightningPacket.class, LightningPacket::new),
        PACKET_MATTER_CANNON(MatterCannonPacket.class, MatterCannonPacket::new),
        PACKET_MOCK_EXPLOSION(MockExplosionPacket.class, MockExplosionPacket::new),
        PACKET_VALUE_CONFIG(ConfigValuePacket.class, ConfigValuePacket::new),
        PACKET_ITEM_TRANSITION_EFFECT(ItemTransitionEffectPacket.class, ItemTransitionEffectPacket::new),
        PACKET_BLOCK_TRANSITION_EFFECT(BlockTransitionEffectPacket.class, BlockTransitionEffectPacket::new),
        PACKET_PROGRESS_VALUE(ProgressBarPacket.class, ProgressBarPacket::new),
        PACKET_CLICK(ClickPacket.class, ClickPacket::new),
        PACKET_SWITCH_GUIS(SwitchGuisPacket.class, SwitchGuisPacket::new),
        PACKET_SWAP_SLOTS(SwapSlotsPacket.class, SwapSlotsPacket::new),
        PACKET_PATTERN_SLOT(PatternSlotPacket.class, PatternSlotPacket::new),
        PACKET_RECIPE_JEI(JEIRecipePacket.class, JEIRecipePacket::new),
        PACKET_TARGET_ITEM(TargetItemStackPacket.class, TargetItemStackPacket::new),
        PACKET_TARGET_FLUID(TargetFluidStackPacket.class, TargetFluidStackPacket::new),
        PACKET_CRAFTING_REQUEST(CraftRequestPacket.class, CraftRequestPacket::new),
        PACKET_ASSEMBLER_ANIMATION(AssemblerAnimationPacket.class, AssemblerAnimationPacket::new),
        PACKET_ME_INTERFACE_UPDATE(MEInterfaceUpdatePacket.class, MEInterfaceUpdatePacket::new),
        PACKET_PAINTED_ENTITY(PaintedEntityPacket.class, PaintedEntityPacket::new),
        PACKET_FLUID_TANK(FluidSlotPacket.class, FluidSlotPacket::new);

        private final Function<PacketBuffer, BasePacket> factory;

        private PacketTypes(Class<? extends BasePacket> packetClass, Function<PacketBuffer, BasePacket> factory) {
            this.factory = factory;
            REVERSE_LOOKUP.put(packetClass, this);
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends BasePacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public BasePacket parsePacket(PacketBuffer in) throws IllegalArgumentException {
            return this.factory.apply(in);
        }
    }
}

