/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEPartLocation;
import appeng.client.render.effects.EnergyParticleData;
import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTransitionEffectPacket
extends BasePacket {
    private final double x;
    private final double y;
    private final double z;
    private final AEPartLocation d;

    public ItemTransitionEffectPacket(double x, double y, double z, AEPartLocation direction) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.d = direction;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeFloat((float)x);
        data.writeFloat((float)y);
        data.writeFloat((float)z);
        data.writeByte(this.d.ordinal());
        this.configureWrite(data);
    }

    public ItemTransitionEffectPacket(PacketBuffer stream) {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
        this.d = AEPartLocation.fromOrdinal(stream.readByte());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        World world = AppEng.proxy.getWorld();
        EnergyParticleData data = new EnergyParticleData(true, this.d);
        for (int zz = 0; zz < 8; ++zz) {
            if (!AppEng.proxy.shouldAddParticles(Platform.getRandom())) continue;
            double x = this.x + (double)Platform.getRandomFloat() * 0.5 - 0.25;
            double y = this.y + (double)Platform.getRandomFloat() * 0.5 - 0.25;
            double z = this.z + (double)Platform.getRandomFloat() * 0.5 - 0.25;
            double speedX = 0.1f * (float)this.d.xOffset;
            double speedY = 0.1f * (float)this.d.yOffset;
            double speedZ = 0.1f * (float)this.d.zOffset;
            Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)data, x, y, z, speedX, speedY, speedZ);
        }
    }
}

