/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.items.AEBaseItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ReplicatorCardItem
extends AEBaseItem {
    public ReplicatorCardItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.func_201670_d()) {
            CompoundNBT tag = playerIn.func_184586_b(handIn).func_196082_o();
            int replications = tag.func_74764_b("r") ? (tag.func_74762_e("r") + 1) % 4 : 0;
            tag.func_74768_a("r", replications);
            playerIn.func_145747_a((ITextComponent)new StringTextComponent(replications + 1 + "\u00b3 Replications"), Util.field_240973_b_);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        Hand hand = context.func_221531_n();
        if (player == null) {
            return ActionResultType.PASS;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (player.func_213453_ef()) {
            if (world.func_175625_s(pos) instanceof IGridHost) {
                CompoundNBT tag = player.func_184586_b(hand).func_196082_o();
                tag.func_74768_a("x", x);
                tag.func_74768_a("y", y);
                tag.func_74768_a("z", z);
                tag.func_74768_a("side", side.ordinal());
                tag.func_74778_a("w", world.func_234923_W_().func_240901_a_().toString());
                tag.func_74768_a("r", 0);
                this.outputMsg((Entity)player, "Set replicator source");
            } else {
                this.outputMsg((Entity)player, "This is not a Grid Tile.");
            }
        } else {
            CompoundNBT ish = player.func_184586_b(hand).func_77978_p();
            if (ish != null) {
                int src_x = ish.func_74762_e("x");
                int src_y = ish.func_74762_e("y");
                int src_z = ish.func_74762_e("z");
                int src_side = ish.func_74762_e("side");
                String worldId = ish.func_74779_i("w");
                ServerWorld src_w = world.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(worldId)));
                int replications = ish.func_74762_e("r") + 1;
                TileEntity te = src_w.func_175625_s(new BlockPos(src_x, src_y, src_z));
                if (te instanceof IGridHost) {
                    IGridHost gh = (IGridHost)te;
                    Direction sideOff = Direction.values()[src_side];
                    Direction currentSideOff = side;
                    IGridNode n = gh.getGridNode(AEPartLocation.fromFacing(sideOff));
                    if (n != null) {
                        IGrid g = n.getGrid();
                        if (g != null) {
                            ISpatialCache sc = (ISpatialCache)g.getCache(ISpatialCache.class);
                            if (sc.isValidRegion()) {
                                DimensionalCoord min = sc.getMin();
                                DimensionalCoord max = sc.getMax();
                                int sc_size_x = max.x - min.x;
                                int sc_size_y = max.y - min.y;
                                int sc_size_z = max.z - min.z;
                                int min_x = min.x;
                                int min_y = min.y;
                                int min_z = min.z;
                                int x_rot = (int)(-Math.signum(MathHelper.func_76142_g((float)player.field_70177_z)));
                                int z_rot = (int)Math.signum(MathHelper.func_76142_g((float)(player.field_70177_z + 90.0f)));
                                for (int r_x = 0; r_x < replications; ++r_x) {
                                    for (int r_y = 0; r_y < replications; ++r_y) {
                                        for (int r_z = 0; r_z < replications; ++r_z) {
                                            int rel_x = min.x - src_x + x + r_x * sc_size_x * x_rot;
                                            int rel_y = min.y - src_y + y + r_y * sc_size_y;
                                            int rel_z = min.z - src_z + z + r_z * sc_size_z * z_rot;
                                            for (int i = 1; i < sc_size_x; ++i) {
                                                for (int j = 1; j < sc_size_y; ++j) {
                                                    for (int k = 1; k < sc_size_z; ++k) {
                                                        BlockPos p = new BlockPos(min_x + i, min_y + j, min_z + k);
                                                        BlockPos d = new BlockPos(i + rel_x, j + rel_y, k + rel_z);
                                                        BlockState state = src_w.func_180495_p(p);
                                                        Block blk = state.func_177230_c();
                                                        BlockState prev = world.func_180495_p(d);
                                                        world.func_175656_a(d, state);
                                                        if (blk != null && blk.hasTileEntity(state)) {
                                                            TileEntity ote = src_w.func_175625_s(p);
                                                            TileEntity nte = blk.createTileEntity(state, (IBlockReader)world);
                                                            CompoundNBT data = new CompoundNBT();
                                                            ote.func_189515_b(data);
                                                            nte.func_230337_a_(state, data.func_74737_b());
                                                            world.func_175690_a(d, nte);
                                                        }
                                                        world.func_184138_a(d, prev, state, 3);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            } else {
                                this.outputMsg((Entity)player, "requires valid spatial pylon setup.");
                            }
                        } else {
                            this.outputMsg((Entity)player, "no grid?");
                        }
                    } else {
                        this.outputMsg((Entity)player, "No grid node?");
                    }
                } else {
                    this.outputMsg((Entity)player, "Src is no longer a grid block?");
                }
            } else {
                this.outputMsg((Entity)player, "No Source Defined");
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void outputMsg(Entity player, String string) {
        player.func_145747_a((ITextComponent)new StringTextComponent(string), Util.field_240973_b_);
    }
}

