/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.features.AEFeature;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.implementations.tiles.ICrystalGrowthAccelerator;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.entity.AEBaseItemEntity;
import appeng.items.misc.CrystalSeedItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public final class GrowingCrystalEntity
extends AEBaseItemEntity {
    public static EntityType<GrowingCrystalEntity> TYPE;
    private static final int[] GROWTH_TICK_PROGRESS;
    private int progress_1000 = 0;

    public GrowingCrystalEntity(EntityType<? extends GrowingCrystalEntity> type, World world) {
        super(type, world);
    }

    public GrowingCrystalEntity(World w, double x, double y, double z, ItemStack is) {
        super(TYPE, w, x, y, z, is);
        this.func_174873_u();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ItemStack is = this.func_92059_d();
        Item gc = is.func_77973_b();
        if (!(gc instanceof IGrowableCrystal)) {
            return;
        }
        this.applyGrowthTick((IGrowableCrystal)gc, is);
    }

    private void applyGrowthTick(IGrowableCrystal cry, ItemStack is) {
        int z;
        int y;
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            return;
        }
        int x = MathHelper.func_76128_c((double)this.func_226277_ct_());
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)((this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0)), z = MathHelper.func_76128_c((double)this.func_226281_cx_()));
        BlockState state = this.field_70170_p.func_180495_p(pos);
        float multiplier = cry.getMultiplier(state, this.field_70170_p, pos);
        if (multiplier <= 0.0f) {
            this.progress_1000 = 0;
            return;
        }
        int progressPerTick = (int)Math.max(1.0f, (float)this.getSpeed(pos) * multiplier);
        if (this.field_70170_p.func_201670_d()) {
            int len = GrowingCrystalEntity.getTicksBetweenParticleEffects(progressPerTick);
            if (++this.progress_1000 >= len) {
                this.progress_1000 = 0;
                AppEng.proxy.spawnEffect(EffectType.Vibrant, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.2, this.func_226281_cx_(), null);
            }
        } else {
            this.progress_1000 += progressPerTick;
            if (this.progress_1000 >= 1000) {
                ItemStack newItem = is.func_77946_l();
                do {
                    newItem = cry.triggerGrowth(newItem);
                    this.progress_1000 -= 1000;
                } while (this.progress_1000 >= 1000 && newItem.func_77973_b() == is.func_77973_b());
                this.func_92058_a(newItem);
            }
        }
    }

    private static int getTicksBetweenParticleEffects(int progressPerTick) {
        if (progressPerTick > 500) {
            return 1;
        }
        if (progressPerTick > 360) {
            return 3;
        }
        if (progressPerTick > 240) {
            return 7;
        }
        if (progressPerTick > 150) {
            return 10;
        }
        if (progressPerTick > 90) {
            return 15;
        }
        if (progressPerTick > 2) {
            return 20;
        }
        return 40;
    }

    private int getSpeed(BlockPos pos) {
        int acceleratorCount = this.getAcceleratorCount(pos);
        if (acceleratorCount < 0) {
            return GROWTH_TICK_PROGRESS[0];
        }
        if (acceleratorCount >= GROWTH_TICK_PROGRESS.length) {
            return GROWTH_TICK_PROGRESS[GROWTH_TICK_PROGRESS.length - 1];
        }
        return GROWTH_TICK_PROGRESS[acceleratorCount];
    }

    private int getAcceleratorCount(BlockPos pos) {
        int count = 0;
        BlockPos.Mutable testPos = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            if (!this.isPoweredAccelerator((BlockPos)testPos.func_239622_a_((Vector3i)pos, direction))) continue;
            ++count;
        }
        return count;
    }

    private boolean isPoweredAccelerator(BlockPos pos) {
        TileEntity te = this.field_70170_p.func_175625_s(pos);
        return te instanceof ICrystalGrowthAccelerator && ((ICrystalGrowthAccelerator)te).isPowered();
    }

    protected void func_203043_v() {
        ItemStack item = this.func_92059_d();
        if (item.func_77973_b() instanceof CrystalSeedItem) {
            Vector3d v = this.func_213322_ci();
            double yAccel = this.func_189652_ae() ? 0.0 : -0.002;
            this.func_213293_j(v.field_72450_a * 0.99, v.field_72448_b + yAccel, v.field_72449_c * 0.99);
            return;
        }
        super.func_203043_v();
    }

    static {
        GROWTH_TICK_PROGRESS = new int[]{1, 40, 92, 159, 247, 361, 509};
    }
}

