/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseMEScreen;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.me.FluidRepo;
import appeng.client.me.InternalFluidSlotME;
import appeng.client.me.SlotFluidME;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.fluids.container.slots.IMEFluidSlot;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class FluidTerminalScreen
extends AEBaseMEScreen<FluidTerminalContainer>
implements ISortSource,
IConfigManagerHost {
    private final List<SlotFluidME> meFluidSlots = new LinkedList<SlotFluidME>();
    private final FluidRepo repo;
    private final IConfigManager configSrc;
    private static final int GRID_OFFSET_X = 9;
    private static final int GRID_OFFSET_Y = 18;
    private static final int ROWS = 6;
    private static final int COLS = 9;
    private AETextField searchField;
    private SettingToggleButton<SortOrder> sortByBox;
    private SettingToggleButton<SortDir> sortDirBox;

    public FluidTerminalScreen(FluidTerminalContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_146999_f = 185;
        this.field_147000_g = 222;
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new FluidRepo(scrollbar, this);
        this.configSrc = container.getConfigManager();
        ((FluidTerminalContainer)this.field_147002_h).setGui(this);
    }

    @Override
    public void func_231160_c_() {
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.searchField = new AETextField(this.field_230712_o_, this.field_147003_i + 80, this.field_147009_r + 4, 90, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.setSelectionColor(-6684775);
        this.searchField.func_146189_e(true);
        int offset = this.field_147009_r;
        this.sortByBox = (SettingToggleButton)this.func_230480_a_((Widget)new SettingToggleButton<SortOrder>(this.field_147003_i - 18, offset, Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
        this.sortDirBox = (SettingToggleButton)this.func_230480_a_((Widget)new SettingToggleButton<SortDir>(this.field_147003_i - 18, offset += 20, Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting));
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                SlotFluidME slot = new SlotFluidME(new InternalFluidSlotME(this.repo, x + y * 9, 9 + x * 18, 18 + y * 18));
                this.getMeFluidSlots().add(slot);
                ((FluidTerminalContainer)this.field_147002_h).field_75151_b.add(slot);
            }
        }
        this.setScrollBar();
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.FluidTerminal.getLocal(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.inventory.getLocal(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture(this.getBackground());
        int x_width = 197;
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)offsetY, (int)0, (int)0, (int)197, (int)18, (float)this.func_230927_p_());
        for (int x = 0; x < 6; ++x) {
            GuiUtils.drawTexturedModalRect((int)offsetX, (int)(offsetY + 18 + x * 18), (int)0, (int)18, (int)197, (int)18, (float)this.func_230927_p_());
        }
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)(offsetY + 16 + 108), (int)0, (int)70, (int)197, (int)176, (float)this.func_230927_p_());
        if (this.searchField != null) {
            this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void func_231023_e_() {
        this.repo.setPower(((FluidTerminalContainer)this.field_147002_h).isPowered());
        super.func_231023_e_();
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        IMEFluidSlot fluidSlot;
        Slot slot = this.getSlot(mouseX, mouseY);
        if (slot instanceof IMEFluidSlot && slot.func_111238_b() && (fluidSlot = (IMEFluidSlot)slot).getAEFluidStack() != null && fluidSlot.shouldRenderAsFluid()) {
            IAEFluidStack fluidStack = fluidSlot.getAEFluidStack();
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format((double)fluidStack.getStackSize() / 1000.0) + " B";
            String modName = Platform.getModName(Platform.getModId(fluidStack));
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(fluidStack.getFluidStack().getDisplayName());
            list.add(new StringTextComponent(formattedAmount));
            list.add(new StringTextComponent(modName));
            this.func_243308_b(matrixStack, list, mouseX, mouseY);
            return;
        }
        super.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    private <S extends Enum<S>> void toggleServerSetting(SettingToggleButton<S> btn, boolean backwards) {
        S next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting().name(), ((Enum)next).name()));
        btn.set(next);
    }

    @Override
    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof SlotFluidME) {
            SlotFluidME meSlot = (SlotFluidME)slot;
            if (clickType == ClickType.PICKUP) {
                if (mouseButton == 0 && meSlot.func_75216_d()) {
                    ((FluidTerminalContainer)this.field_147002_h).setTargetStack(meSlot.getAEFluidStack());
                    AELog.debug("mouse0 GUI STACK SIZE %s", meSlot.getAEFluidStack().getStackSize());
                    NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.FILL_ITEM, slot.field_75222_d, 0L));
                } else {
                    ((FluidTerminalContainer)this.field_147002_h).setTargetStack(meSlot.getAEFluidStack());
                    if (meSlot.getAEFluidStack() != null) {
                        AELog.debug("mouse1 GUI STACK SIZE %s", meSlot.getAEFluidStack().getStackSize());
                    }
                    NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.EMPTY_ITEM, slot.field_75222_d, 0L));
                }
            }
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    public boolean func_231042_a_(char character, int p_charTyped_2_) {
        if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
            return true;
        }
        if (this.searchField.func_230999_j_() && this.searchField.func_231042_a_(character, p_charTyped_2_)) {
            this.repo.setSearchString(this.searchField.func_146179_b());
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode != 256 && !this.checkHotbarKeys(input)) {
            if (AppEng.proxy.isActionKey(ActionKey.TOGGLE_FOCUS, input)) {
                this.searchField.func_146195_b(!this.searchField.func_230999_j_());
                return true;
            }
            if (this.searchField.func_230999_j_()) {
                if (keyCode == 257) {
                    this.searchField.func_146195_b(false);
                    return true;
                }
                if (this.searchField.func_231046_a_(keyCode, scanCode, p_keyPressed_3_)) {
                    this.repo.setSearchString(this.searchField.func_146179_b());
                    this.repo.updateView();
                    this.setScrollBar();
                }
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    @Override
    public boolean func_231044_a_(double xCoord, double yCoord, int btn) {
        if (this.searchField.func_231044_a_(xCoord, yCoord, btn)) {
            return true;
        }
        if (this.searchField.func_231047_b_(xCoord, yCoord) && btn == 1) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return super.func_231044_a_(xCoord, yCoord, btn);
    }

    public void postUpdate(List<IAEFluidStack> list) {
        for (IAEFluidStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(106);
        this.getScrollBar().setRange(0, (this.repo.size() + 9 - 1) / 9 - 6, 1);
    }

    @Override
    public SortOrder getSortBy() {
        return (SortOrder)this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return (SortDir)this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return (ViewItems)this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.sortByBox != null) {
            this.sortByBox.set(this.getSortBy());
        }
        if (this.sortDirBox != null) {
            this.sortDirBox.set(this.getSortDir());
        }
        this.repo.updateView();
    }

    protected List<SlotFluidME> getMeFluidSlots() {
        return this.meFluidSlots;
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }
}

