/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.render;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.render.StackSizeRenderer;
import appeng.core.AEConfig;
import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.minecraft.client.gui.FontRenderer;

public class FluidStackSizeRenderer {
    private static final String[] NUMBER_FORMATS = new String[]{"#.000", "#.00", "#.0", "#"};
    private static final ISlimReadableNumberConverter SLIM_CONVERTER = ReadableNumberConverter.INSTANCE;
    private static final IWideReadableNumberConverter WIDE_CONVERTER = ReadableNumberConverter.INSTANCE;

    public void renderStackSize(FontRenderer fontRenderer, IAEFluidStack aeStack, int xPos, int yPos) {
        if (aeStack != null && aeStack.getStackSize() > 0L) {
            String stackSize = this.getToBeRenderedStackSize(aeStack.getStackSize());
            StackSizeRenderer.renderSizeLabel(fontRenderer, xPos, yPos, stackSize);
        }
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (originalSize < 100000L && AEConfig.instance().isUseLargeFonts()) {
            return this.getSlimRenderedStacksize(originalSize);
        }
        if (originalSize < 1000000L && !AEConfig.instance().isUseLargeFonts()) {
            return this.getWideRenderedStacksize(originalSize);
        }
        if (AEConfig.instance().isUseLargeFonts()) {
            return SLIM_CONVERTER.toSlimReadableForm(originalSize / 1000L);
        }
        return WIDE_CONVERTER.toWideReadableForm(originalSize / 1000L);
    }

    private String getSlimRenderedStacksize(long originalSize) {
        int log = 1 + (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private String getWideRenderedStacksize(long originalSize) {
        int log = (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private String getRenderedFluidStackSize(long originalSize, int log) {
        int index = Math.max(0, Math.min(3, log));
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(NUMBER_FORMATS[index]);
        format.setDecimalFormatSymbols(symbols);
        format.setRoundingMode(RoundingMode.DOWN);
        return format.format((double)originalSize / 1000.0);
    }
}

