/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.util.AEColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;

public class Splotch {
    private final Direction side;
    private final boolean lumen;
    private final AEColor color;
    private final int pos;

    public Splotch(AEColor col, boolean lit, Direction side, Vector3d position) {
        double y;
        double x;
        this.color = col;
        this.lumen = lit;
        if (side == Direction.SOUTH || side == Direction.NORTH) {
            x = position.field_72450_a;
            y = position.field_72448_b;
        } else if (side == Direction.UP || side == Direction.DOWN) {
            x = position.field_72450_a;
            y = position.field_72449_c;
        } else {
            x = position.field_72448_b;
            y = position.field_72449_c;
        }
        int a = (int)(x * 15.0);
        int b = (int)(y * 15.0);
        this.pos = a | b << 4;
        this.side = side;
    }

    public Splotch(PacketBuffer data) {
        this.pos = data.readByte();
        byte val = data.readByte();
        this.side = Direction.values()[val & 7];
        this.color = AEColor.values()[val >> 3 & 0xF];
        this.lumen = (val >> 7 & 1) > 0;
    }

    public void writeToStream(PacketBuffer stream) {
        stream.writeByte(this.pos);
        int val = this.getSide().ordinal() | this.getColor().ordinal() << 3 | (this.isLumen() ? 128 : 0);
        stream.writeByte(val);
    }

    public float x() {
        return (float)(this.pos & 0xF) / 15.0f;
    }

    public float y() {
        return (float)(this.pos >> 4 & 0xF) / 15.0f;
    }

    public int getSeed() {
        int val = this.getSide().ordinal() | this.getColor().ordinal() << 3 | (this.isLumen() ? 128 : 0);
        return Math.abs(this.pos + val);
    }

    public Direction getSide() {
        return this.side;
    }

    public AEColor getColor() {
        return this.color;
    }

    public boolean isLumen() {
        return this.lumen;
    }
}

