/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.JEIRecipePacket;
import java.util.Map;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

abstract class RecipeTransferHandler<T extends Container>
implements IRecipeTransferHandler<T> {
    private final Class<T> containerClass;
    protected final IRecipeTransferHandlerHelper helper;

    RecipeTransferHandler(Class<T> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public final Class<T> getContainerClass() {
        return this.containerClass;
    }

    public final IRecipeTransferError transferRecipe(T container, Object recipe, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (!(recipe instanceof IRecipe)) {
            return this.helper.createInternalError();
        }
        IRecipe irecipe = (IRecipe)recipe;
        ResourceLocation recipeId = irecipe.func_199560_c();
        if (recipeId == null) {
            return this.helper.createUserErrorWithTooltip(I18n.func_135052_a((String)"jei.appliedenergistics2.missing_id", (Object[])new Object[0]));
        }
        boolean canSendReference = true;
        if (!player.func_130014_f_().func_199532_z().func_215367_a(recipeId).isPresent()) {
            if (!(recipe instanceof ShapedRecipe) && !(recipe instanceof ShapelessRecipe)) {
                return this.helper.createUserErrorWithTooltip(I18n.func_135052_a((String)"jei.appliedenergistics2.missing_id", (Object[])new Object[0]));
            }
            canSendReference = false;
        }
        if (!irecipe.func_194133_a(3, 3)) {
            return this.helper.createUserErrorWithTooltip(I18n.func_135052_a((String)"jei.appliedenergistics2.recipe_too_large", (Object[])new Object[0]));
        }
        IRecipeTransferError error = this.doTransferRecipe(container, irecipe, recipeLayout, player, maxTransfer);
        if (error != null) {
            return error;
        }
        if (doTransfer) {
            if (canSendReference) {
                NetworkHandler.instance().sendToServer(new JEIRecipePacket(recipeId, this.isCrafting()));
            } else {
                NonNullList flatIngredients = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
                ItemStack output = ItemStack.field_190927_a;
                int firstInputSlot = recipeLayout.getItemStacks().getGuiIngredients().entrySet().stream().filter(e -> ((IGuiIngredient)e.getValue()).isInput()).mapToInt(Map.Entry::getKey).min().orElse(0);
                for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
                    IGuiIngredient item = (IGuiIngredient)entry.getValue();
                    if (item.getDisplayedIngredient() == null) continue;
                    int inputIndex = (Integer)entry.getKey() - firstInputSlot;
                    if (item.isInput() && inputIndex < flatIngredients.size()) {
                        ItemStack displayedIngredient = (ItemStack)item.getDisplayedIngredient();
                        if (displayedIngredient == null) continue;
                        flatIngredients.set(inputIndex, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{displayedIngredient}));
                        continue;
                    }
                    if (item.isInput() || !output.func_190926_b()) continue;
                    output = (ItemStack)item.getDisplayedIngredient();
                }
                ShapedRecipe fallbackRecipe = new ShapedRecipe(recipeId, "", 3, 3, flatIngredients, output);
                NetworkHandler.instance().sendToServer(new JEIRecipePacket(fallbackRecipe, this.isCrafting()));
            }
        }
        return null;
    }

    protected abstract IRecipeTransferError doTransferRecipe(T var1, IRecipe<?> var2, IRecipeLayout var3, PlayerEntity var4, boolean var5);

    protected abstract boolean isCrafting();
}

