/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IPlayerRegistry;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.networking.security.ISecurityRegistry;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BiometricCardItem
extends AEBaseItem
implements IBiometricCard {
    public BiometricCardItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity p, Hand hand) {
        if (p.func_213453_ef()) {
            this.encode(p.func_184586_b(hand), p);
            p.func_184609_a(hand);
            return ActionResult.func_226248_a_((Object)p.func_184586_b(hand));
        }
        return ActionResult.func_226250_c_((Object)p.func_184586_b(hand));
    }

    public ActionResultType func_111207_a(ItemStack is, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target instanceof PlayerEntity && !player.func_213453_ef()) {
            if (player.func_184812_l_()) {
                is = player.func_184586_b(hand);
            }
            this.encode(is, (PlayerEntity)target);
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ITextComponent func_200295_i(ItemStack is) {
        GameProfile username = this.getProfile(is);
        return username != null ? super.func_200295_i(is).func_230532_e_().func_240702_b_(" - " + username.getName()) : super.func_200295_i(is);
    }

    private void encode(ItemStack is, PlayerEntity p) {
        GameProfile username = this.getProfile(is);
        if (username != null && username.equals((Object)p.func_146103_bH())) {
            this.setProfile(is, null);
        } else {
            this.setProfile(is, p.func_146103_bH());
        }
    }

    @Override
    public void setProfile(ItemStack itemStack, GameProfile profile) {
        CompoundNBT tag = itemStack.func_196082_o();
        if (profile != null) {
            CompoundNBT pNBT = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)pNBT, (GameProfile)profile);
            tag.func_218657_a("profile", (INBT)pNBT);
        } else {
            tag.func_82580_o("profile");
        }
    }

    @Override
    public GameProfile getProfile(ItemStack is) {
        CompoundNBT tag = is.func_196082_o();
        if (tag.func_74764_b("profile")) {
            return NBTUtil.func_152459_a((CompoundNBT)tag.func_74775_l("profile"));
        }
        return null;
    }

    @Override
    public EnumSet<SecurityPermissions> getPermissions(ItemStack is) {
        CompoundNBT tag = is.func_196082_o();
        EnumSet<SecurityPermissions> result = EnumSet.noneOf(SecurityPermissions.class);
        for (SecurityPermissions sp : SecurityPermissions.values()) {
            if (!tag.func_74767_n(sp.name())) continue;
            result.add(sp);
        }
        return result;
    }

    @Override
    public boolean hasPermission(ItemStack is, SecurityPermissions permission) {
        CompoundNBT tag = is.func_196082_o();
        return tag.func_74767_n(permission.name());
    }

    @Override
    public void removePermission(ItemStack itemStack, SecurityPermissions permission) {
        CompoundNBT tag = itemStack.func_196082_o();
        if (tag.func_74764_b(permission.name())) {
            tag.func_82580_o(permission.name());
        }
    }

    @Override
    public void addPermission(ItemStack itemStack, SecurityPermissions permission) {
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_74757_a(permission.name(), true);
    }

    @Override
    public void registerPermissions(ISecurityRegistry register, IPlayerRegistry pr, ItemStack is) {
        register.addPlayer(pr.getID(this.getProfile(is)), this.getPermissions(is));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        EnumSet<SecurityPermissions> perms = this.getPermissions(stack);
        if (perms.isEmpty()) {
            lines.add((ITextComponent)new TranslationTextComponent(GuiText.NoPermissions.getLocal()));
        } else {
            TranslationTextComponent msg = null;
            for (SecurityPermissions sp : perms) {
                if (msg == null) {
                    msg = new TranslationTextComponent(sp.getTranslatedName());
                    continue;
                }
                msg = msg.func_230532_e_().func_240702_b_(", ").func_230529_a_((ITextComponent)new TranslationTextComponent(sp.getTranslatedName()));
            }
            lines.add((ITextComponent)msg);
        }
    }
}

