/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.INetworkToolAgent;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.NetworkStatusContainer;
import appeng.container.implementations.NetworkToolContainer;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ClickPacket;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolViewer;
import appeng.util.Platform;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class NetworkToolItem
extends AEBaseItem
implements IGuiItem,
IAEWrench {
    public NetworkToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, int playerInventorySlot, World world, BlockPos pos) {
        if (pos == null) {
            return new NetworkToolViewer(is, null);
        }
        TileEntity te = world.func_175625_s(pos);
        return new NetworkToolViewer(is, (IGridHost)(te instanceof IGridHost ? te : null));
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity p, Hand hand) {
        RayTraceResult mop;
        if (Platform.isClient() && ((mop = AppEng.proxy.getRTR()) == null || mop.func_216346_c() == RayTraceResult.Type.MISS)) {
            NetworkHandler.instance().sendToServer(new ClickPacket(hand));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)p.func_184586_b(hand));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        BlockRayTraceResult mop = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (te instanceof IPartHost) {
            SelectedPart part = ((IPartHost)te).selectPart(mop.func_216347_e());
            if (part.part != null || part.facade != null) {
                if (part.part instanceof INetworkToolAgent && !((INetworkToolAgent)((Object)part.part)).showNetworkInfo((RayTraceResult)mop)) {
                    return ActionResultType.FAIL;
                }
                if (context.func_195999_j().func_213453_ef()) {
                    return ActionResultType.PASS;
                }
            }
        } else if (te instanceof INetworkToolAgent && !((INetworkToolAgent)te).showNetworkInfo((RayTraceResult)mop)) {
            return ActionResultType.FAIL;
        }
        if (Platform.isClient()) {
            NetworkHandler.instance().sendToServer(new ClickPacket(context));
        }
        return ActionResultType.SUCCESS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean serverSideToolLogic(ItemUseContext useContext) {
        TileEntity te;
        BlockPos pos = useContext.func_195995_a();
        PlayerEntity p = useContext.func_195999_j();
        World w = p.field_70170_p;
        Hand hand = useContext.func_221531_n();
        Direction side = useContext.func_196000_l();
        if (!Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
            return false;
        }
        BlockState bs = w.func_180495_p(pos);
        if (!p.func_213453_ef() && !((te = w.func_175625_s(pos)) instanceof IGridHost) && bs.rotate((IWorld)w, pos, Rotation.CLOCKWISE_90) != bs) {
            bs.func_215697_a(w, pos, Blocks.field_150350_a, pos, false);
            p.func_184609_a(hand);
            return !w.field_72995_K;
        }
        if (!p.func_213453_ef()) {
            if (p.field_71070_bA instanceof AEBaseContainer) {
                return true;
            }
            te = w.func_175625_s(pos);
            if (te instanceof IGridHost) {
                ContainerOpener.openContainer(NetworkStatusContainer.TYPE, p, ContainerLocator.forItemUseContext(useContext));
            } else {
                ContainerOpener.openContainer(NetworkToolContainer.TYPE, p, ContainerLocator.forHand(p, hand));
            }
            return true;
        }
        BlockRayTraceResult rtr = new BlockRayTraceResult(useContext.func_221532_j(), side, pos, false);
        bs.func_227031_a_(w, p, hand, rtr);
        return false;
    }

    @Override
    public boolean canWrench(ItemStack wrench, PlayerEntity player, BlockPos pos) {
        return true;
    }
}

