/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.config.YesNo;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.implementations.parts.ICablePart;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.facade.FacadeContainer;
import appeng.helpers.AEMultiTile;
import appeng.me.GridConnection;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusStorage;
import appeng.parts.ICableBusContainer;
import appeng.parts.PartPlacement;
import appeng.parts.VoxelShapeCache;
import appeng.parts.networking.CablePart;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CableBusContainer
extends CableBusStorage
implements AEMultiTile,
ICableBusContainer {
    private static final ThreadLocal<Boolean> IS_LOADING = new ThreadLocal();
    private final EnumSet<LayerFlags> myLayerFlags = EnumSet.noneOf(LayerFlags.class);
    private YesNo hasRedstone = YesNo.UNDECIDED;
    private IPartHost tcb;
    private boolean requiresDynamicRender = false;
    private boolean inWorld = false;
    private VoxelShape cachedCollisionShapeLiving;
    private VoxelShape cachedCollisionShape;
    private VoxelShape cachedShape;

    public CableBusContainer(IPartHost host) {
        this.tcb = host;
    }

    public static boolean isLoading() {
        Boolean is = IS_LOADING.get();
        return is != null && is != false;
    }

    public void setHost(IPartHost host) {
        this.tcb.clearContainer();
        this.tcb = host;
    }

    public void rotateLeft() {
        IPart[] newSides = new IPart[6];
        newSides[AEPartLocation.UP.ordinal()] = this.getSide(AEPartLocation.UP);
        newSides[AEPartLocation.DOWN.ordinal()] = this.getSide(AEPartLocation.DOWN);
        newSides[AEPartLocation.EAST.ordinal()] = this.getSide(AEPartLocation.NORTH);
        newSides[AEPartLocation.SOUTH.ordinal()] = this.getSide(AEPartLocation.EAST);
        newSides[AEPartLocation.WEST.ordinal()] = this.getSide(AEPartLocation.SOUTH);
        newSides[AEPartLocation.NORTH.ordinal()] = this.getSide(AEPartLocation.WEST);
        for (AEPartLocation dir : AEPartLocation.SIDE_LOCATIONS) {
            this.setSide(dir, newSides[dir.ordinal()]);
        }
        this.getFacadeContainer().rotateLeft();
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return new FacadeContainer(this, this::invalidateShapes);
    }

    @Override
    public boolean canAddPart(ItemStack is, AEPartLocation side) {
        if (PartPlacement.isFacade(is, side) != null) {
            return true;
        }
        if (is.func_77973_b() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.func_77973_b();
            is = is.func_77946_l();
            is.func_190920_e(1);
            Object bp = bi.createPart(is);
            if (bp != null) {
                if (bp instanceof ICablePart) {
                    boolean canPlace = true;
                    for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                        if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((ICablePart)bp).supportsBuses())) continue;
                        canPlace = false;
                    }
                    if (!canPlace) {
                        return false;
                    }
                    return this.getPart(AEPartLocation.INTERNAL) == null;
                }
                if (!(bp instanceof ICablePart) && side != AEPartLocation.INTERNAL) {
                    IPart cable = this.getPart(AEPartLocation.INTERNAL);
                    if (cable != null && !bp.canBePlacedOn(((ICablePart)cable).supportsBuses())) {
                        return false;
                    }
                    return this.getPart(side) == null;
                }
            }
        }
        return false;
    }

    @Override
    public AEPartLocation addPart(ItemStack is, AEPartLocation side, @Nullable PlayerEntity player, @Nullable Hand hand) {
        if (this.canAddPart(is, side) && is.func_77973_b() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.func_77973_b();
            is = is.func_77946_l();
            is.func_190920_e(1);
            Object bp = bi.createPart(is);
            if (bp instanceof ICablePart) {
                IGridNode cn;
                boolean canPlace = true;
                for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                    if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((ICablePart)bp).supportsBuses())) continue;
                    canPlace = false;
                }
                if (!canPlace) {
                    return null;
                }
                if (this.getPart(AEPartLocation.INTERNAL) != null) {
                    return null;
                }
                this.setCenter((ICablePart)bp);
                bp.setPartHostInfo(AEPartLocation.INTERNAL, this, this.tcb.getTile());
                if (player != null) {
                    bp.onPlacement(player, hand, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if ((cn = this.getCenter().getGridNode()) != null) {
                    for (AEPartLocation ins : AEPartLocation.SIDE_LOCATIONS) {
                        IGridNode sn;
                        IPart sbp = this.getPart(ins);
                        if (sbp == null || (sn = sbp.getGridNode()) == null) continue;
                        try {
                            GridConnection.create(cn, sn, AEPartLocation.INTERNAL);
                        }
                        catch (FailedConnectionException e) {
                            AELog.debug(e);
                            bp.removeFromWorld();
                            this.setCenter(null);
                            return null;
                        }
                    }
                }
                this.invalidateShapes();
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return AEPartLocation.INTERNAL;
            }
            if (bp != null && !(bp instanceof ICablePart) && side != AEPartLocation.INTERNAL) {
                IPart cable = this.getPart(AEPartLocation.INTERNAL);
                if (cable != null && !bp.canBePlacedOn(((ICablePart)cable).supportsBuses())) {
                    return null;
                }
                this.setSide(side, (IPart)bp);
                bp.setPartHostInfo(side, this, this.getTile());
                if (player != null) {
                    bp.onPlacement(player, hand, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if (this.getCenter() != null) {
                    IGridNode cn = this.getCenter().getGridNode();
                    IGridNode sn = bp.getGridNode();
                    if (cn != null && sn != null) {
                        try {
                            GridConnection.create(cn, sn, AEPartLocation.INTERNAL);
                        }
                        catch (FailedConnectionException e) {
                            AELog.debug(e);
                            bp.removeFromWorld();
                            this.setSide(side, null);
                            return null;
                        }
                    }
                }
                this.invalidateShapes();
                this.updateDynamicRender();
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return side;
            }
        }
        return null;
    }

    @Override
    public IPart getPart(AEPartLocation partLocation) {
        if (partLocation == AEPartLocation.INTERNAL) {
            return this.getCenter();
        }
        return this.getSide(partLocation);
    }

    @Override
    public IPart getPart(Direction side) {
        return this.getSide(AEPartLocation.fromFacing(side));
    }

    @Override
    public void removePart(AEPartLocation side, boolean suppressUpdate) {
        if (side == AEPartLocation.INTERNAL) {
            if (this.getCenter() != null) {
                this.getCenter().removeFromWorld();
            }
            this.setCenter(null);
        } else {
            if (this.getSide(side) != null) {
                this.getSide(side).removeFromWorld();
            }
            this.setSide(side, null);
        }
        if (!suppressUpdate) {
            this.invalidateShapes();
            this.updateDynamicRender();
            this.updateConnections();
            this.markForUpdate();
            this.markForSave();
            this.partChanged();
        }
    }

    @Override
    public void markForUpdate() {
        this.tcb.markForUpdate();
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.tcb.getLocation();
    }

    @Override
    public TileEntity getTile() {
        return this.tcb.getTile();
    }

    @Override
    public AEColor getColor() {
        if (this.getCenter() != null) {
            ICablePart c = this.getCenter();
            return c.getCableColor();
        }
        return AEColor.TRANSPARENT;
    }

    @Override
    public void clearContainer() {
        throw new UnsupportedOperationException("Now that is silly!");
    }

    @Override
    public boolean isBlocked(Direction side) {
        return this.tcb.isBlocked(side);
    }

    @Override
    public SelectedPart selectPart(Vector3d pos) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            BusCollisionHelper bch = new BusCollisionHelper(boxes, side, true);
            p.getBoxes(bch);
            for (AxisAlignedBB bb : boxes) {
                if (!(bb = bb.func_72314_b(0.002, 0.002, 0.002)).func_72318_a(pos)) continue;
                return new SelectedPart(p, side);
            }
        }
        if (Api.instance().partHelper().getCableRenderMode().opaqueFacades) {
            IFacadeContainer fc = this.getFacadeContainer();
            for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                IFacadePart p = fc.getFacade(side);
                if (p == null) continue;
                ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, true);
                p.getBoxes(bch, true);
                for (AxisAlignedBB bb : boxes) {
                    if (!(bb = bb.func_72314_b(0.01, 0.01, 0.01)).func_72318_a(pos)) continue;
                    return new SelectedPart(p, side);
                }
            }
        }
        return new SelectedPart();
    }

    @Override
    public void markForSave() {
        this.tcb.markForSave();
    }

    @Override
    public void partChanged() {
        if (this.getCenter() == null) {
            ArrayList<ItemStack> facades = new ArrayList<ItemStack>();
            IFacadeContainer fc = this.getFacadeContainer();
            for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                IFacadePart fp = fc.getFacade(d);
                if (fp == null) continue;
                facades.add(fp.getItemStack());
                fc.removeFacade(this.tcb, d);
            }
            if (!facades.isEmpty()) {
                TileEntity te = this.tcb.getTile();
                Platform.spawnDrops(te.func_145831_w(), te.func_174877_v(), facades);
            }
        }
        this.tcb.partChanged();
    }

    @Override
    public boolean hasRedstone(AEPartLocation side) {
        if (this.hasRedstone == YesNo.UNDECIDED) {
            this.updateRedstone();
        }
        return this.hasRedstone == YesNo.YES;
    }

    @Override
    public boolean isEmpty() {
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                return false;
            }
            if (s == AEPartLocation.INTERNAL || (fp = fc.getFacade(s)) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.myLayerFlags;
    }

    @Override
    public void cleanup() {
        this.tcb.cleanup();
    }

    @Override
    public void notifyNeighbors() {
        this.tcb.notifyNeighbors();
    }

    @Override
    public boolean isInWorld() {
        return this.inWorld;
    }

    private void updateRedstone() {
        TileEntity te = this.getTile();
        this.hasRedstone = te.func_145831_w().func_175687_A(te.func_174877_v()) != 0 ? YesNo.YES : YesNo.NO;
    }

    private void updateDynamicRender() {
        this.requiresDynamicRender = false;
        for (AEPartLocation s : AEPartLocation.SIDE_LOCATIONS) {
            IPart p = this.getPart(s);
            if (p == null) continue;
            this.setRequiresDynamicRender(this.isRequiresDynamicRender() || p.requireDynamicRender());
        }
    }

    public void updateConnections() {
        if (this.getCenter() != null) {
            EnumSet<Direction> sides = EnumSet.allOf(Direction.class);
            for (Direction s : Direction.values()) {
                if (this.getPart(s) == null && !this.isBlocked(s)) continue;
                sides.remove(s);
            }
            this.getCenter().setValidSides(sides);
            IGridNode n = this.getCenter().getGridNode();
            if (n != null) {
                n.updateState();
            }
        }
    }

    public void addToWorld() {
        if (this.inWorld) {
            return;
        }
        this.inWorld = true;
        IS_LOADING.set(true);
        TileEntity te = this.getTile();
        for (int x = 6; x >= 0; --x) {
            IGridNode cn;
            IPart center;
            IGridNode sn;
            AEPartLocation s = AEPartLocation.fromOrdinal(x);
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.setPartHostInfo(s, this, te);
            part.addToWorld();
            if (s == AEPartLocation.INTERNAL || (sn = part.getGridNode()) == null || (center = this.getPart(AEPartLocation.INTERNAL)) == null || (cn = center.getGridNode()) == null) continue;
            try {
                Api.instance().grid().createGridConnection(cn, sn);
                continue;
            }
            catch (FailedConnectionException e) {
                AELog.debug(e);
            }
        }
        this.partChanged();
        IS_LOADING.set(false);
    }

    public void removeFromWorld() {
        if (!this.inWorld) {
            return;
        }
        this.inWorld = false;
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.removeFromWorld();
        }
        this.invalidateShapes();
        this.partChanged();
    }

    @Override
    public IGridNode getGridNode(AEPartLocation side) {
        IGridNode n;
        IPart part = this.getPart(side);
        if (part != null && (n = part.getExternalFacingNode()) != null) {
            return n;
        }
        if (this.getCenter() != null) {
            return this.getCenter().getGridNode();
        }
        return null;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        AECableType t;
        IPart part = this.getPart(dir);
        if (part instanceof IGridHost && (t = ((IGridHost)((Object)part)).getCableConnectionType(dir)) != null && t != AECableType.NONE) {
            return t;
        }
        if (this.getCenter() != null) {
            ICablePart c = this.getCenter();
            return c.getCableConnectionType();
        }
        return AECableType.NONE;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getPart(AEPartLocation.INTERNAL) instanceof ICablePart ? this.getPart(AEPartLocation.INTERNAL).getCableConnectionLength(cable) : -1.0f;
    }

    @Override
    public void securityBreak() {
        for (AEPartLocation d : AEPartLocation.values()) {
            IPart p = this.getPart(d);
            if (!(p instanceof IGridHost)) continue;
            ((IGridHost)((Object)p)).securityBreak();
        }
    }

    @Override
    public int isProvidingStrongPower(Direction side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingStrongPower() : 0;
    }

    @Override
    public int isProvidingWeakPower(Direction side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingWeakPower() : 0;
    }

    @Override
    public boolean canConnectRedstone(Direction opposite) {
        IPart part = this.getPart(opposite);
        return part != null && part.canConnectRedstone();
    }

    @Override
    public void onEntityCollision(Entity entity) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onEntityCollision(entity);
        }
    }

    @Override
    public boolean activate(PlayerEntity player, Hand hand, Vector3d pos) {
        SelectedPart p = this.selectPart(pos);
        if (p != null && p.part != null) {
            if (player.func_213453_ef() && p.part.onShiftActivate(player, hand, pos)) {
                return true;
            }
            return p.part.onActivate(player, hand, pos);
        }
        return false;
    }

    @Override
    public boolean clicked(PlayerEntity player, Hand hand, Vector3d hitVec) {
        SelectedPart p = this.selectPart(hitVec);
        if (p != null && p.part != null) {
            if (player.func_213453_ef()) {
                return p.part.onShiftClicked(player, hand, hitVec);
            }
            return p.part.onClicked(player, hand, hitVec);
        }
        return false;
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        this.hasRedstone = YesNo.UNDECIDED;
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onNeighborChanged(w, pos, neighbor);
        }
        this.invalidateShapes();
    }

    @Override
    public boolean isLadder(LivingEntity entity) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null || !p.isLadder(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void animateTick(World world, BlockPos pos, Random r) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            p.animateTick(world, pos, r);
        }
    }

    @Override
    public int getLightValue() {
        int light = 0;
        for (AEPartLocation d : AEPartLocation.values()) {
            IPart p = this.getPart(d);
            if (p == null) continue;
            light = Math.max(p.getLightLevel(), light);
        }
        return light;
    }

    public void writeToStream(PacketBuffer data) throws IOException {
        IPart p;
        int x;
        int sides = 0;
        for (x = 0; x < 7; ++x) {
            p = this.getPart(AEPartLocation.fromOrdinal(x));
            if (p == null) continue;
            sides |= 1 << x;
        }
        data.writeByte((int)((byte)sides));
        for (x = 0; x < 7; ++x) {
            p = this.getPart(AEPartLocation.fromOrdinal(x));
            if (p == null) continue;
            ItemStack is = p.getItemStack(PartItemStack.NETWORK);
            data.func_150787_b(Item.func_150891_b((Item)is.func_77973_b()));
            p.writeToStream(data);
        }
        this.getFacadeContainer().writeToStream(data);
    }

    public boolean readFromStream(PacketBuffer data) throws IOException {
        byte sides = data.readByte();
        boolean updateBlock = false;
        for (int x = 0; x < 7; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            if ((sides & 1 << x) == 1 << x) {
                ItemStack current;
                IPart p = this.getPart(side);
                int itemID = data.func_150792_a();
                Item myItem = Item.func_150899_d((int)itemID);
                ItemStack itemStack = current = p != null ? p.getItemStack(PartItemStack.NETWORK) : null;
                if (current != null && current.func_77973_b() == myItem) {
                    if (!p.readFromStream(data)) continue;
                    updateBlock = true;
                    continue;
                }
                this.removePart(side, false);
                side = this.addPart(new ItemStack((IItemProvider)myItem, 1), side, null, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromStream(data);
                    continue;
                }
                throw new IllegalStateException("Invalid Stream For CableBus Container.");
            }
            if (this.getPart(side) == null) continue;
            this.removePart(side, false);
        }
        this.invalidateShapes();
        return updateBlock |= this.getFacadeContainer().readFromStream(data);
    }

    public void writeToNBT(CompoundNBT data) {
        data.func_74768_a("hasRedstone", this.hasRedstone.ordinal());
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            fc.writeToNBT(data);
            IPart part = this.getPart(s);
            if (part == null) continue;
            CompoundNBT def = new CompoundNBT();
            part.getItemStack(PartItemStack.WORLD).func_77955_b(def);
            CompoundNBT extra = new CompoundNBT();
            part.writeToNBT(extra);
            data.func_218657_a("def:" + this.getSide(part).ordinal(), (INBT)def);
            data.func_218657_a("extra:" + this.getSide(part).ordinal(), (INBT)extra);
        }
    }

    private AEPartLocation getSide(IPart part) {
        if (this.getCenter() == part) {
            return AEPartLocation.INTERNAL;
        }
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            if (this.getSide(side) != part) continue;
            return side;
        }
        throw new IllegalStateException("Uhh Bad Part (" + part + ") on Side.");
    }

    public void readFromNBT(CompoundNBT data) {
        this.invalidateShapes();
        if (data.func_74764_b("hasRedstone")) {
            this.hasRedstone = YesNo.values()[data.func_74762_e("hasRedstone")];
        }
        for (int x = 0; x < 7; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            String defKey = "def:" + side.ordinal();
            String extraKey = "extra:" + side.ordinal();
            if (data.func_150297_b(defKey, 10) && data.func_150297_b(extraKey, 10)) {
                ItemStack current;
                CompoundNBT def = data.func_74775_l(defKey);
                CompoundNBT extra = data.func_74775_l(extraKey);
                IPart p = this.getPart(side);
                ItemStack iss = ItemStack.func_199557_a((CompoundNBT)def);
                if (iss.func_190926_b()) continue;
                ItemStack itemStack = current = p == null ? ItemStack.field_190927_a : p.getItemStack(PartItemStack.WORLD);
                if (Platform.itemComparisons().isEqualItemType(iss, current)) {
                    p.readFromNBT(extra);
                    continue;
                }
                this.removePart(side, true);
                side = this.addPart(iss, side, null, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromNBT(extra);
                    continue;
                }
                AELog.warn("Invalid NBT For CableBus Container: " + iss.func_77973_b().getClass().getName() + " is not a valid part; it was ignored.", new Object[0]);
                continue;
            }
            this.removePart(side, false);
        }
        this.getFacadeContainer().readFromNBT(data);
    }

    public List<ItemStack> getDrops(List<ItemStack> drops) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                drops.add(part.getItemStack(PartItemStack.BREAK));
                part.getDrops(drops, false);
            }
            if (s == AEPartLocation.INTERNAL || (fp = this.getFacadeContainer().getFacade(s)) == null) continue;
            drops.add(fp.getItemStack());
        }
        return drops;
    }

    public List<ItemStack> getNoDrops(List<ItemStack> drops) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.getDrops(drops, false);
        }
        return drops;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor colour, PlayerEntity who) {
        IPart cable = this.getPart(AEPartLocation.INTERNAL);
        if (cable != null) {
            ICablePart pc = (ICablePart)cable;
            return pc.changeColor(colour, who);
        }
        return false;
    }

    public boolean isRequiresDynamicRender() {
        return this.requiresDynamicRender;
    }

    private void setRequiresDynamicRender(boolean requiresDynamicRender) {
        this.requiresDynamicRender = requiresDynamicRender;
    }

    @Override
    public CableBusRenderState getRenderState() {
        CablePart cable = (CablePart)this.getCenter();
        CableBusRenderState renderState = new CableBusRenderState();
        if (cable != null) {
            renderState.setCableColor(cable.getCableColor());
            renderState.setCableType(cable.getCableConnectionType());
            renderState.setCoreType(CableCoreType.fromCableType(cable.getCableConnectionType()));
            for (Direction facing : Direction.values()) {
                if (!cable.isConnected(facing)) continue;
                AECableType connectionType = cable.getCableConnectionType();
                BlockPos adjacentPos = this.getTile().func_174877_v().func_177972_a(facing);
                TileEntity adjacentTe = this.getTile().func_145831_w().func_175625_s(adjacentPos);
                if (adjacentTe instanceof IGridHost) {
                    IGridHost gridHost = (IGridHost)adjacentTe;
                    AECableType adjacentType = gridHost.getCableConnectionType(AEPartLocation.fromFacing(facing.func_176734_d()));
                    connectionType = AECableType.min(connectionType, adjacentType);
                }
                if (adjacentTe instanceof IPartHost) {
                    renderState.getCableBusAdjacent().add(facing);
                }
                renderState.getConnectionTypes().put(facing, connectionType);
            }
            for (Direction facing : Direction.values()) {
                int channels = cable.getCableConnectionType().isSmart() ? cable.getChannelsOnSide(facing) : 0;
                renderState.getChannelsOnSide().put(facing, channels);
            }
        }
        for (Direction facing : Direction.values()) {
            IPart part;
            FacadeRenderState facadeState = this.getFacadeRenderState(facing);
            if (facadeState != null) {
                renderState.getFacades().put(facing, facadeState);
            }
            if ((part = this.getPart(facing)) == null) continue;
            renderState.getPartModelData().put(facing, part.getModelData());
            AEPartLocation loc = AEPartLocation.fromFacing(facing);
            BusCollisionHelper bch = new BusCollisionHelper(renderState.getBoundingBoxes(), loc, true);
            part.getBoxes(bch);
            if (part instanceof IGridHost) {
                int length;
                IGridHost gridHost = (IGridHost)((Object)part);
                AECableType desiredType = gridHost.getCableConnectionType(AEPartLocation.INTERNAL);
                if (renderState.getCoreType() == CableCoreType.GLASS && (desiredType == AECableType.SMART || desiredType == AECableType.COVERED)) {
                    renderState.setCoreType(CableCoreType.COVERED);
                }
                if ((length = (int)part.getCableConnectionLength(null)) > 0 && length <= 8) {
                    renderState.getAttachmentConnections().put(facing, length);
                }
            }
            renderState.getAttachments().put(facing, part.getStaticModels());
        }
        return renderState;
    }

    private FacadeRenderState getFacadeRenderState(Direction side) {
        IFacadePart facade = this.getFacade(side.ordinal());
        if (facade != null) {
            ItemStack textureItem = facade.getTextureItem();
            BlockState blockState = facade.getBlockState();
            World world = this.getTile().func_145831_w();
            if (blockState != null && textureItem != null && world != null) {
                return new FacadeRenderState(blockState, !facade.getBlockState().func_200015_d((IBlockReader)world, this.getTile().func_174877_v()));
            }
        }
        return null;
    }

    public VoxelShape getShape() {
        if (this.cachedShape == null) {
            this.cachedShape = this.createShape(false, false);
        }
        return this.cachedShape;
    }

    public VoxelShape getCollisionShape(Entity entity) {
        boolean livingEntity = entity instanceof LivingEntity;
        if (livingEntity) {
            if (this.cachedCollisionShapeLiving == null) {
                this.cachedCollisionShapeLiving = this.createShape(true, true);
            }
            return this.cachedCollisionShapeLiving;
        }
        if (this.cachedCollisionShape == null) {
            this.cachedCollisionShape = this.createShape(true, false);
        }
        return this.cachedCollisionShape;
    }

    private VoxelShape createShape(boolean forCollision, boolean forLivingEntity) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            BusCollisionHelper bch = new BusCollisionHelper(boxes, s, !forCollision);
            IPart part = this.getPart(s);
            if (part != null) {
                part.getBoxes(bch);
            }
            if (!Api.instance().partHelper().getCableRenderMode().opaqueFacades && !forCollision || s == AEPartLocation.INTERNAL || (fp = fc.getFacade(s)) == null) continue;
            fp.getBoxes(bch, forLivingEntity);
        }
        return VoxelShapeCache.get(boxes);
    }

    private void invalidateShapes() {
        this.cachedShape = null;
        this.cachedCollisionShape = null;
        this.cachedCollisionShapeLiving = null;
    }
}

