/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.parts.networking.CablePart;
import appeng.util.Platform;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public abstract class DenseCablePart
extends CablePart {
    public DenseCablePart(ItemStack is) {
        super(is);
        this.getProxy().setFlags(GridFlags.DENSE_CAPACITY, GridFlags.PREFERRED);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.DENSE_CABLE;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean noLadder = !bch.isBBCollision();
        double min = noLadder ? 3.0 : 4.9;
        double max = noLadder ? 13.0 : 11.1;
        bch.addBox(min, min, min, max, max, max);
        if (Platform.isServer()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.setConnections(n.getConnectedSides());
            } else {
                this.getConnections().clear();
            }
        }
        block16: for (AEPartLocation of : this.getConnections()) {
            if (this.isDense(of)) {
                switch (of) {
                    case DOWN: {
                        bch.addBox(min, 0.0, min, max, min, max);
                        continue block16;
                    }
                    case EAST: {
                        bch.addBox(max, min, min, 16.0, max, max);
                        continue block16;
                    }
                    case NORTH: {
                        bch.addBox(min, min, 0.0, max, max, min);
                        continue block16;
                    }
                    case SOUTH: {
                        bch.addBox(min, min, max, max, max, 16.0);
                        continue block16;
                    }
                    case UP: {
                        bch.addBox(min, max, min, max, 16.0, max);
                        continue block16;
                    }
                    case WEST: {
                        bch.addBox(0.0, min, min, min, max, max);
                        continue block16;
                    }
                }
                continue;
            }
            switch (of) {
                case DOWN: {
                    bch.addBox(5.0, 0.0, 5.0, 11.0, 5.0, 11.0);
                    break;
                }
                case EAST: {
                    bch.addBox(11.0, 5.0, 5.0, 16.0, 11.0, 11.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(5.0, 5.0, 0.0, 11.0, 11.0, 5.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(5.0, 11.0, 5.0, 11.0, 16.0, 11.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 5.0, 5.0, 5.0, 11.0, 11.0);
                    break;
                }
            }
        }
    }

    private boolean isDense(AEPartLocation of) {
        TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(of.getFacing()));
        if (te instanceof IGridHost) {
            AECableType t = ((IGridHost)te).getCableConnectionType(of.getOpposite());
            return t.isDense();
        }
        return false;
    }

    @MENetworkEventSubscribe
    public void channelUpdated(MENetworkChannelsChanged c) {
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }
}

