/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidP2PTunnelPart
extends P2PTunnelPart<FluidP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fluids");
    private static final IFluidHandler NULL_FLUID_HANDLER = new NullFluidHandler();
    private final IFluidHandler inputHandler = new InputFluidHandler();
    private final IFluidHandler outputHandler = new OutputFluidHandler();

    public FluidP2PTunnelPart(ItemStack is) {
        super(is);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void onTunnelNetworkChange() {
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        FluidP2PTunnelPart in;
        if (this.isOutput() && (in = (FluidP2PTunnelPart)this.getInput()) != null) {
            in.onTunnelNetworkChange();
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.isOutput()) {
                return LazyOptional.of(() -> this.outputHandler);
            }
            return LazyOptional.of(() -> this.inputHandler);
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private IFluidHandler getAttachedFluidHandler() {
        TileEntity self;
        TileEntity te;
        LazyOptional fluidHandler = LazyOptional.empty();
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) != null) {
            fluidHandler = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getOpposite().getFacing());
        }
        return (IFluidHandler)fluidHandler.orElse((Object)NULL_FLUID_HANDLER);
    }

    private static class NullFluidHandler
    implements IFluidHandler {
        private NullFluidHandler() {
        }

        public int getTanks() {
            return 0;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private class OutputFluidHandler
    implements IFluidHandler {
        private OutputFluidHandler() {
        }

        public int getTanks() {
            return ((FluidP2PTunnelPart)FluidP2PTunnelPart.this.getInput()).getAttachedFluidHandler().getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return ((FluidP2PTunnelPart)FluidP2PTunnelPart.this.getInput()).getAttachedFluidHandler().getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return ((FluidP2PTunnelPart)FluidP2PTunnelPart.this.getInput()).getAttachedFluidHandler().getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return ((FluidP2PTunnelPart)FluidP2PTunnelPart.this.getInput()).getAttachedFluidHandler().isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return ((FluidP2PTunnelPart)FluidP2PTunnelPart.this.getInput()).getAttachedFluidHandler().drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return ((FluidP2PTunnelPart)FluidP2PTunnelPart.this.getInput()).getAttachedFluidHandler().drain(maxDrain, action);
        }
    }

    private class InputFluidHandler
    implements IFluidHandler {
        private InputFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int total = 0;
            try {
                int outputTunnels = FluidP2PTunnelPart.this.getOutputs().size();
                int amount = resource.getAmount();
                if (outputTunnels == 0 || amount == 0) {
                    return 0;
                }
                int amountPerOutput = Math.max(1, amount / outputTunnels);
                int overflow = amountPerOutput == 0 ? amount : amount % amountPerOutput;
                for (FluidP2PTunnelPart target : FluidP2PTunnelPart.this.getOutputs()) {
                    IFluidHandler output = target.getAttachedFluidHandler();
                    int toSend = amountPerOutput + overflow;
                    FluidStack fillWithFluidStack = resource.copy();
                    fillWithFluidStack.setAmount(toSend);
                    int received = output.fill(fillWithFluidStack, action);
                    overflow = toSend - received;
                    total += received;
                }
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    FluidP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, total);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return total;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

