/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemP2PTunnelPart
extends P2PTunnelPart<ItemP2PTunnelPart> {
    private static final float POWER_DRAIN = 2.0f;
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_items");
    private static final IItemHandler NULL_ITEM_HANDLER = new NullItemHandler();
    private final IItemHandler inputHandler = new InputItemHandler();
    private final IItemHandler outputHandler = new OutputItemHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public ItemP2PTunnelPart(ItemStack is) {
        super(is);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isOutput()) {
                return LazyOptional.of(() -> this.outputHandler);
            }
            return LazyOptional.of(() -> this.inputHandler);
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private IItemHandler getAttachedItemHandler() {
        TileEntity self;
        TileEntity te;
        LazyOptional itemHandler = LazyOptional.empty();
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) != null) {
            itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().getOpposite().getFacing());
        }
        return (IItemHandler)itemHandler.orElse((Object)NULL_ITEM_HANDLER);
    }

    private static class NullItemHandler
    implements IItemHandler {
        private NullItemHandler() {
        }

        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }

    private class OutputItemHandler
    implements IItemHandler {
        private OutputItemHandler() {
        }

        public int getSlots() {
            return ((ItemP2PTunnelPart)ItemP2PTunnelPart.this.getInput()).getAttachedItemHandler().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ((ItemP2PTunnelPart)ItemP2PTunnelPart.this.getInput()).getAttachedItemHandler().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ((ItemP2PTunnelPart)ItemP2PTunnelPart.this.getInput()).getAttachedItemHandler().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return ((ItemP2PTunnelPart)ItemP2PTunnelPart.this.getInput()).getAttachedItemHandler().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return ((ItemP2PTunnelPart)ItemP2PTunnelPart.this.getInput()).getAttachedItemHandler().isItemValid(slot, stack);
        }
    }

    private class InputItemHandler
    implements IItemHandler {
        private InputItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack remainder = stack.func_77946_l();
            try {
                int outputTunnels = ItemP2PTunnelPart.this.getOutputs().size();
                int amount = stack.func_190916_E();
                if (outputTunnels == 0 || amount == 0) {
                    return stack;
                }
                int amountPerOutput = Math.max(1, amount / outputTunnels);
                int overflow = amountPerOutput == 0 ? amount : amount % amountPerOutput;
                for (ItemP2PTunnelPart target : ItemP2PTunnelPart.this.getOutputs()) {
                    IItemHandler output = target.getAttachedItemHandler();
                    int toSend = amountPerOutput + overflow;
                    ItemStack fillWithItemStack = stack.func_77946_l();
                    fillWithItemStack.func_190920_e(toSend);
                    ItemStack received = ItemStack.field_190927_a;
                    for (int i = 0; i < output.getSlots() && !(received = output.insertItem(i, fillWithItemStack, simulate)).func_190926_b(); ++i) {
                    }
                    overflow = received.func_190916_E();
                    remainder.func_190920_e(remainder.func_190916_E() - toSend - received.func_190916_E());
                    if (!remainder.func_190926_b()) continue;
                    break;
                }
                if (!simulate) {
                    ItemP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, stack.func_190916_E() - remainder.func_190916_E());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return remainder;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

