/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.hooks.TickHandler;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.Connections;
import appeng.me.cache.helpers.TunnelConnection;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.world.IWorld;

public class MEP2PTunnelPart
extends P2PTunnelPart<MEP2PTunnelPart>
implements IGridTickable {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_me");
    private final Connections connection = new Connections(this);
    private final AENetworkProxy outerProxy = new AENetworkProxy(this, "outer", ItemStack.field_190927_a, true);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public MEP2PTunnelPart(ItemStack is) {
        super(is);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.COMPRESSED_CHANNEL);
        this.outerProxy.setFlags(GridFlags.DENSE_CAPACITY, GridFlags.CANNOT_CARRY_COMPRESSED);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void readFromNBT(CompoundNBT extra) {
        super.readFromNBT(extra);
        this.outerProxy.readFromNBT(extra);
    }

    @Override
    public void writeToNBT(CompoundNBT extra) {
        super.writeToNBT(extra);
        this.outerProxy.writeToNBT(extra);
    }

    @Override
    public void onTunnelNetworkChange() {
        super.onTunnelNetworkChange();
        if (!this.isOutput()) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerProxy.remove();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerProxy.onReady();
    }

    @Override
    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        this.outerProxy.setValidSides(EnumSet.of(side.getFacing()));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerProxy.getNode();
    }

    @Override
    public void onPlacement(PlayerEntity player, Hand hand, ItemStack held, AEPartLocation side) {
        super.onPlacement(player, hand, held, side);
        this.outerProxy.setOwner(player);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.METunnel.getMin(), TickRates.METunnel.getMax(), true, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        try {
            if (!this.getProxy().getPath().isNetworkBooting()) {
                if (!this.getProxy().getEnergy().isNetworkPowered()) {
                    this.connection.markDestroy();
                    TickHandler.instance().addCallable((IWorld)this.getTile().func_145831_w(), this.connection);
                } else if (this.getProxy().isActive()) {
                    this.connection.markCreate();
                    TickHandler.instance().addCallable((IWorld)this.getTile().func_145831_w(), this.connection);
                } else {
                    this.connection.markDestroy();
                    TickHandler.instance().addCallable((IWorld)this.getTile().func_145831_w(), this.connection);
                }
                return TickRateModulation.SLEEP;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return TickRateModulation.IDLE;
    }

    public void updateConnections(Connections connections) {
        if (connections.isDestroy()) {
            for (TunnelConnection cw : this.connection.getConnections().values()) {
                cw.getConnection().destroy();
            }
            this.connection.getConnections().clear();
        } else if (connections.isCreate()) {
            Iterator<TunnelConnection> i = this.connection.getConnections().values().iterator();
            while (i.hasNext()) {
                TunnelConnection cw = i.next();
                try {
                    if (cw.getTunnel().getProxy().getGrid() != this.getProxy().getGrid()) {
                        cw.getConnection().destroy();
                        i.remove();
                        continue;
                    }
                    if (cw.getTunnel().getProxy().isActive()) continue;
                    cw.getConnection().destroy();
                    i.remove();
                }
                catch (GridAccessException gridAccessException) {}
            }
            ArrayList<MEP2PTunnelPart> newSides = new ArrayList<MEP2PTunnelPart>();
            try {
                for (MEP2PTunnelPart me : this.getOutputs()) {
                    if (!me.getProxy().isActive() || connections.getConnections().get(me.getGridNode()) != null) continue;
                    newSides.add(me);
                }
                for (MEP2PTunnelPart me : newSides) {
                    try {
                        connections.getConnections().put(me.getGridNode(), new TunnelConnection(me, Api.instance().grid().createGridConnection(this.outerProxy.getNode(), me.outerProxy.getNode())));
                    }
                    catch (FailedConnectionException e) {
                        TileEntity start = this.getTile();
                        TileEntity end = me.getTile();
                        AELog.debug(e);
                        AELog.warn("Failed to establish a ME P2P Tunnel between the tunnels at [x=%d, y=%d, z=%d] and [x=%d, y=%d, z=%d]", start.func_174877_v().func_177958_n(), start.func_174877_v().func_177956_o(), start.func_174877_v().func_177952_p(), end.func_174877_v().func_177958_n(), end.func_174877_v().func_177956_o(), end.func_174877_v().func_177952_p());
                    }
                }
            }
            catch (GridAccessException e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

