/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IStorageMonitorPart;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.render.TesrRenderHelper;
import appeng.core.Api;
import appeng.core.localization.PlayerMessages;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractMonitorPart
extends AbstractDisplayPart
implements IStorageMonitorPart,
IStackWatcherHost {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private IAEItemStack configuredItem;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;

    public AbstractMonitorPart(ItemStack is) {
        super(is);
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        super.readFromNBT(data);
        this.isLocked = data.func_74767_n("isLocked");
        CompoundNBT myItem = data.func_74775_l("configuredItem");
        this.configuredItem = AEItemStack.fromNBT(myItem);
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        super.writeToNBT(data);
        data.func_74757_a("isLocked", this.isLocked);
        CompoundNBT myItem = new CompoundNBT();
        if (this.configuredItem != null) {
            this.configuredItem.writeToNBT(myItem);
        }
        data.func_218657_a("configuredItem", (INBT)myItem);
    }

    @Override
    public void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            this.configuredItem.writeToPacket(data);
        }
    }

    @Override
    public boolean readFromStream(PacketBuffer data) throws IOException {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw = this.isLocked != isLocked;
        this.isLocked = isLocked;
        boolean val = data.readBoolean();
        this.configuredItem = val ? AEItemStack.fromPacket(data) : null;
        return needRedraw;
    }

    @Override
    public boolean onPartActivate(PlayerEntity player, Hand hand, Vector3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.isLocked) {
            return super.onPartActivate(player, hand, pos);
        }
        ItemStack eq = player.func_184586_b(hand);
        this.configuredItem = AEItemStack.fromItemStack(eq);
        this.configureWatchers();
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    @Override
    public boolean onPartShiftActivate(PlayerEntity player, Hand hand, Vector3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (player.func_184586_b(hand).func_190926_b()) {
            this.isLocked = !this.isLocked;
            player.func_145747_a((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).get(), Util.field_240973_b_);
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        try {
            if (this.configuredItem != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add(this.configuredItem);
                }
                this.updateReportingValue(this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> itemInventory) {
        if (this.configuredItem != null) {
            IAEItemStack result = itemInventory.getStorageList().findPrecise(this.configuredItem);
            if (result == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(result.getStackSize());
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDynamic(float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffers, int combinedLightIn, int combinedOverlayIn) {
        if ((this.getClientFlags() & 0x14) != 20) {
            return;
        }
        IAEItemStack ais = this.getDisplayed();
        if (ais == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Direction facing = this.getSide().getFacing();
        TesrRenderHelper.rotateToFace(matrixStack, facing, this.getSpin());
        matrixStack.func_227861_a_(0.0, 0.05, 0.5);
        TesrRenderHelper.renderItem2dWithAmount(matrixStack, buffers, ais, 0.4f, -0.23f, 0xF000F0, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    public IAEItemStack getDisplayed() {
        return this.configuredItem;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, IActionSource src, IStorageChannel chan) {
        if (this.configuredItem != null) {
            if (fullStack == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(fullStack.getStackSize());
            }
            long stackSize = this.configuredItem.getStackSize();
            String humanReadableText = NUMBER_CONVERTER.toWideReadableForm(stackSize);
            if (!humanReadableText.equals(this.lastHumanReadableText)) {
                this.lastHumanReadableText = humanReadableText;
                this.getHost().markForUpdate();
            }
        }
    }

    @Override
    public boolean showNetworkInfo(RayTraceResult where) {
        return false;
    }

    protected IPartModel selectModel(IPartModel off, IPartModel on, IPartModel hasChannel, IPartModel lockedOff, IPartModel lockedOn, IPartModel lockedHasChannel) {
        if (this.isActive()) {
            if (this.isLocked()) {
                return lockedHasChannel;
            }
            return hasChannel;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return lockedOn;
            }
            return on;
        }
        if (this.isLocked()) {
            return lockedOff;
        }
        return off;
    }
}

