/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.server.ISubCommand;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkLogger
implements ISubCommand {
    private boolean enabled = false;

    private void displayStack() {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CHUNK_LOGGER_TRACE)) {
            boolean output = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (output) {
                    AELog.info("\t\t" + e.getClassName() + '.' + e.getMethodName() + " (" + e.getLineNumber() + ')', new Object[0]);
                    continue;
                }
                output = e.getClassName().contains("EventBus") && e.getMethodName().contains("post");
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            AELog.info("Chunk Loaded:   " + event.getChunk().func_76632_l().field_77276_a + ", " + event.getChunk().func_76632_l().field_77275_b, new Object[0]);
            this.displayStack();
        }
    }

    @SubscribeEvent
    public void onChunkUnloadEvent(ChunkEvent.Unload unload) {
        if (!unload.getWorld().func_201670_d()) {
            AELog.info("Chunk Unloaded: " + unload.getChunk().func_76632_l().field_77276_a + ", " + unload.getChunk().func_76632_l().field_77275_b, new Object[0]);
            this.displayStack();
        }
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSource> data, CommandSource sender) {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ae2.ChunkLoggerOn"), true);
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ae2.ChunkLoggerOff"), true);
        }
    }
}

