/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerNull;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.TargetPoint;
import appeng.core.sync.packets.AssemblerAnimationPacket;
import appeng.items.misc.EncodedPatternItem;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.crafting.AssemblerAnimationStatus;
import appeng.tile.grid.AENetworkInvTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.IItemHandler;

public class MolecularAssemblerTileEntity
extends AENetworkInvTileEntity
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    public static final String INVENTORY_MAIN = "molecular_assembler";
    private final CraftingInventory craftingInv;
    private final AppEngInternalInventory gridInv = new AppEngInternalInventory(this, 10, 1);
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory(this, 1, 1);
    private final IItemHandler gridInvExt = new WrapperFilteredItemHandler((IItemHandler)this.gridInv, new CraftingGridFilter());
    private final IItemHandler internalInv = new WrapperChainedItemHandler(new IItemHandler[]{this.gridInv, this.patternInv});
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private boolean isPowered = false;
    private AEPartLocation pushDirection = AEPartLocation.INTERNAL;
    private ItemStack myPattern = ItemStack.field_190927_a;
    private ICraftingPatternDetails myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;
    @OnlyIn(value=Dist.CLIENT)
    private AssemblerAnimationStatus animationStatus;

    public MolecularAssemblerTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        ITileDefinition assembler = Api.instance().definitions().blocks().molecularAssembler();
        this.settings = new ConfigManager(this);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getProxy().setIdlePowerUsage(0.0);
        this.upgrades = new DefinitionUpgradeInventory(assembler, this, this.getUpgradeSlots());
        this.craftingInv = new CraftingInventory((Container)new ContainerNull(), 3, 3);
    }

    private int getUpgradeSlots() {
        return 5;
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, CraftingInventory table, Direction where) {
        if (this.myPattern.func_190926_b()) {
            boolean isEmpty;
            boolean bl = isEmpty = ItemHandlerUtil.isEmpty((IItemHandler)this.gridInv) && ItemHandlerUtil.isEmpty((IItemHandler)this.patternInv);
            if (isEmpty && patternDetails.isCraftable()) {
                this.forcePlan = true;
                this.myPlan = patternDetails;
                this.pushDirection = AEPartLocation.fromFacing(where);
                for (int x = 0; x < table.func_70302_i_(); ++x) {
                    this.gridInv.setStackInSlot(x, table.func_70301_a(x));
                }
                this.updateSleepiness();
                this.saveChanges();
                return true;
            }
        }
        return false;
    }

    private void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            try {
                if (this.isAwake) {
                    this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
                } else {
                    this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private boolean canPush() {
        return !this.gridInv.getStackInSlot(9).func_190926_b();
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
            this.craftingInv.func_70299_a(x, this.gridInv.getStackInSlot(x));
        }
        return !this.myPlan.getOutput(this.craftingInv, this.func_145831_w()).func_190926_b();
    }

    @Override
    public boolean acceptsPlans() {
        return ItemHandlerUtil.isEmpty((IItemHandler)this.patternInv);
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        ItemStack pattern;
        super.func_189515_b(data);
        if (this.forcePlan && this.myPlan != null && !(pattern = this.myPlan.getPattern()).func_190926_b()) {
            CompoundNBT compound = new CompoundNBT();
            pattern.func_77955_b(compound);
            data.func_218657_a("myPlan", (INBT)compound);
            data.func_74768_a("pushDirection", this.pushDirection.ordinal());
        }
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        ItemStack myPat;
        super.func_230337_a_(blockState, data);
        if (data.func_74764_b("myPlan") && !(myPat = ItemStack.func_199557_a((CompoundNBT)data.func_74775_l("myPlan"))).func_190926_b() && myPat.func_77973_b() instanceof EncodedPatternItem) {
            World w = this.func_145831_w();
            ICraftingPatternDetails ph = Api.instance().crafting().decodePattern(myPat, w);
            if (ph != null && ph.isCraftable()) {
                this.forcePlan = true;
                this.myPlan = ph;
                this.pushDirection = AEPartLocation.fromOrdinal(data.func_74762_e("pushDirection"));
            }
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
        this.recalculatePlan();
    }

    private void recalculatePlan() {
        this.reboot = true;
        if (this.forcePlan) {
            return;
        }
        ItemStack is = this.patternInv.getStackInSlot(0);
        if (!is.func_190926_b() && is.func_77973_b() instanceof EncodedPatternItem) {
            if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)this.myPattern)) {
                World w = this.func_145831_w();
                ICraftingPatternDetails ph = Api.instance().crafting().decodePattern(is, w);
                if (ph != null && ph.isCraftable()) {
                    this.progress = 0.0;
                    this.myPattern = is;
                    this.myPlan = ph;
                }
            }
        } else {
            this.progress = 0.0;
            this.forcePlan = false;
            this.myPlan = null;
            this.myPattern = ItemStack.field_190927_a;
            this.pushDirection = AEPartLocation.INTERNAL;
        }
        this.updateSleepiness();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals(INVENTORY_MAIN)) {
            return this.internalInv;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.internalInv;
    }

    @Override
    protected IItemHandler getItemHandlerForSide(Direction side) {
        return this.gridInvExt;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.gridInv || inv == this.patternInv) {
            this.recalculatePlan();
        }
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int h = 0; h < this.upgrades.getSlots(); ++h) {
            ItemStack is = this.upgrades.getStackInSlot(h);
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        this.recalculatePlan();
        this.updateSleepiness();
        return new TickingRequest(1, 1, !this.isAwake, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridInv.getStackInSlot(9).func_190926_b()) {
            this.pushOut(this.gridInv.getStackInSlot(9));
            if (this.gridInv.getStackInSlot(9).func_190926_b()) {
                this.saveChanges();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        int speed = 10;
        switch (this.upgrades.getInstalledUpgrades(Upgrades.SPEED)) {
            case 0: {
                speed = 10;
                this.progress += (double)this.userPower(ticksSinceLastCall, 10, 1.0);
                break;
            }
            case 1: {
                speed = 13;
                this.progress += (double)this.userPower(ticksSinceLastCall, 13, 1.3);
                break;
            }
            case 2: {
                speed = 17;
                this.progress += (double)this.userPower(ticksSinceLastCall, 17, 1.7);
                break;
            }
            case 3: {
                speed = 20;
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 2.0);
                break;
            }
            case 4: {
                speed = 25;
                this.progress += (double)this.userPower(ticksSinceLastCall, 25, 2.5);
                break;
            }
            case 5: {
                speed = 50;
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
                this.craftingInv.func_70299_a(x, this.gridInv.getStackInSlot(x));
            }
            this.progress = 0.0;
            ItemStack output = this.myPlan.getOutput(this.craftingInv, this.func_145831_w());
            if (!output.func_190926_b()) {
                BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)Platform.getPlayer((ServerWorld)this.func_145831_w()), (ItemStack)output, (IInventory)this.craftingInv);
                this.pushOut(output.func_77946_l());
                for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
                    this.gridInv.setStackInSlot(x, Platform.getContainerItem(this.craftingInv.func_70301_a(x)));
                }
                if (ItemHandlerUtil.isEmpty((IItemHandler)this.patternInv)) {
                    this.forcePlan = false;
                    this.myPlan = null;
                    this.pushDirection = AEPartLocation.INTERNAL;
                }
                this.ejectHeldItems();
                AEItemStack item = AEItemStack.fromItemStack(output);
                if (item != null) {
                    TargetPoint where = new TargetPoint(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 32.0, this.field_145850_b);
                    NetworkHandler.instance().sendToAllAround(new AssemblerAnimationPacket(this.field_174879_c, (byte)speed, item), where);
                }
                this.saveChanges();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    private void ejectHeldItems() {
        if (this.gridInv.getStackInSlot(9).func_190926_b()) {
            for (int x = 0; x < 9; ++x) {
                ItemStack is = this.gridInv.getStackInSlot(x);
                if (is.func_190926_b() || this.myPlan != null && this.myPlan.isValidItemForSlot(x, is, this.field_145850_b)) continue;
                this.gridInv.setStackInSlot(9, is);
                this.gridInv.setStackInSlot(x, ItemStack.field_190927_a);
                this.saveChanges();
                return;
            }
        }
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        try {
            return (int)(this.getProxy().getEnergy().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private void pushOut(ItemStack output) {
        if (this.pushDirection == AEPartLocation.INTERNAL) {
            for (Direction d : Direction.values()) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection.getFacing());
        }
        if (output.func_190926_b() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setStackInSlot(9, output);
    }

    private ItemStack pushTo(ItemStack output, Direction d) {
        int newSize;
        if (output.func_190926_b()) {
            return output;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(d));
        if (te == null) {
            return output;
        }
        InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(te, d.func_176734_d());
        if (adaptor == null) {
            return output;
        }
        int size = output.func_190916_E();
        int n = newSize = (output = adaptor.addItems(output)).func_190926_b() ? 0 : output.func_190916_E();
        if (size != newSize) {
            this.saveChanges();
        }
        return output;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public boolean isActive() {
        return this.isPowered;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setAnimationStatus(@Nullable AssemblerAnimationStatus status) {
        this.animationStatus = status;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public AssemblerAnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    private class CraftingGridFilter
    implements IAEItemFilter {
        private CraftingGridFilter() {
        }

        private boolean hasPattern() {
            return MolecularAssemblerTileEntity.this.myPlan != null && !ItemHandlerUtil.isEmpty((IItemHandler)MolecularAssemblerTileEntity.this.patternInv);
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return slot == 9;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            if (slot >= 9) {
                return false;
            }
            if (this.hasPattern()) {
                return MolecularAssemblerTileEntity.this.myPlan.isValidItemForSlot(slot, stack, MolecularAssemblerTileEntity.this.func_145831_w());
            }
            return false;
        }
    }
}

