/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Comparator;

public class ItemSorters {
    private static SortDir Direction = SortDir.ASCENDING;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_NAME = (o1, o2) -> {
        int cmp = Platform.getItemDisplayName(o1).getString().compareToIgnoreCase(Platform.getItemDisplayName(o2).getString());
        return ItemSorters.applyDirection(cmp);
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_MOD = (o1, o2) -> {
        AEItemStack op1 = (AEItemStack)o1;
        AEItemStack op2 = (AEItemStack)o2;
        int cmp = op1.getModID().compareToIgnoreCase(op2.getModID());
        if (cmp == 0) {
            cmp = Platform.getItemDisplayName(o1).getString().compareToIgnoreCase(Platform.getItemDisplayName(o2).getString());
        }
        return ItemSorters.applyDirection(cmp);
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_SIZE = (o1, o2) -> {
        int cmp = Long.compare(o2.getStackSize(), o1.getStackSize());
        return ItemSorters.applyDirection(cmp);
    };

    private static SortDir getDirection() {
        return Direction;
    }

    public static void setDirection(SortDir direction) {
        Direction = direction;
    }

    private static int applyDirection(int cmp) {
        if (ItemSorters.getDirection() == SortDir.ASCENDING) {
            return cmp;
        }
        return -cmp;
    }
}

