/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import mezz.jei.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RecipesGui
extends Screen
implements IRecipesGui,
IShowsRecipeFocuses,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final RecipeTransferManager recipeTransferManager;
    private final IClientConfig clientConfig;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<RecipeLayout<?>> recipeLayouts = new ArrayList();
    private String pageString = "1/1";
    private String title = "";
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final HoverChecker titleHoverChecker = new HoverChecker();
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private Screen parentScreen;
    private Rectangle2d area = new Rectangle2d(0, 0, 0, 0);
    private Rectangle2d titleArea = new Rectangle2d(0, 0, 0, 0);
    private boolean init = false;
    private boolean closing = false;

    public RecipesGui(IRecipeManager recipeManager, RecipeTransferManager recipeTransferManager, IngredientManager ingredientManager, IModIdHelper modIdHelper, IClientConfig clientConfig) {
        super((ITextComponent)new StringTextComponent("Recipes"));
        this.recipeTransferManager = recipeTransferManager;
        this.clientConfig = clientConfig;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, ingredientManager, modIdHelper);
        this.recipeCatalysts = new RecipeCatalysts();
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic);
        this.field_230706_i_ = Minecraft.func_71410_x();
        Textures textures = Internal.getTextures();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory());
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory());
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage());
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage());
        this.background = textures.getGuiBackground();
    }

    private static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer font, String string, Rectangle2d area) {
        Rectangle2d textArea = MathUtil.centerTextArea(area, font, string);
        font.func_238405_a_(matrixStack, string, (float)textArea.func_199318_a(), (float)textArea.func_199319_b(), -1);
    }

    public Rectangle2d getArea() {
        return this.area;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        int xSize = 198;
        int ySize = this.field_230709_l_ - 68;
        int extraSpace = 0;
        int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (width - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = new Rectangle2d(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        this.field_230712_o_.getClass();
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.field_230690_l_ = rightButtonX;
        this.nextRecipeCategory.field_230691_m_ = recipeClassButtonTop;
        this.previousRecipeCategory.field_230690_l_ = leftButtonX;
        this.previousRecipeCategory.field_230691_m_ = recipeClassButtonTop;
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.field_230690_l_ = rightButtonX;
        this.nextPage.field_230691_m_ = pageButtonTop;
        this.previousPage.field_230690_l_ = leftButtonX;
        this.previousPage.field_230691_m_ = pageButtonTop;
        this.headerHeight = pageButtonTop + 13 - guiTop;
        int titleX = this.previousRecipeCategory.field_230690_l_ + this.previousRecipeCategory.func_230998_h_();
        this.titleArea = new Rectangle2dBuilder(titleX, recipeClassButtonTop, this.nextRecipeCategory.field_230690_l_ - titleX, titleHeight).insetByPadding(14).build();
        this.addButtons();
        this.init = true;
        this.updateLayout();
    }

    private void addButtons() {
        this.func_230480_a_((Widget)this.nextRecipeCategory);
        this.func_230480_a_((Widget)this.nextRecipeCategory);
        this.func_230480_a_((Widget)this.previousRecipeCategory);
        this.func_230480_a_((Widget)this.nextPage);
        this.func_230480_a_((Widget)this.previousPage);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_ == null) {
            return;
        }
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.area.func_199318_a();
        int y = this.area.func_199319_b();
        int width = this.area.func_199316_c();
        int height = this.area.func_199317_d();
        this.background.draw(matrixStack, x, y, width, height);
        RenderSystem.disableBlend();
        RecipesGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 6 + 13), (int)this.nextRecipeCategory.field_230691_m_, (int)(x + width - 6 - 13), (int)(this.nextRecipeCategory.field_230691_m_ + 13), (int)0x30000000);
        RecipesGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 6 + 13), (int)this.nextPage.field_230691_m_, (int)(x + width - 6 - 13), (int)(this.nextPage.field_230691_m_ + 13), (int)0x30000000);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(matrixStack, this.field_230712_o_, this.title, this.titleArea);
        Rectangle2d pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(matrixStack, this.field_230712_o_, this.pageString, pageArea);
        this.nextRecipeCategory.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.nextPage.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.previousPage.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RecipeLayout<?> hoveredLayout = null;
        for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(matrixStack, mouseX, mouseY);
        }
        GuiIngredient<?> hoveredRecipeCatalyst = this.recipeCatalysts.draw(matrixStack, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.field_230706_i_, matrixStack, mouseX, mouseY);
        if (hoveredLayout != null) {
            hoveredLayout.drawOverlays(matrixStack, mouseX, mouseY);
        }
        if (hoveredRecipeCatalyst != null) {
            hoveredRecipeCatalyst.drawOverlays(matrixStack, 0, 0, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            TranslationTextComponent showAllRecipesString = new TranslationTextComponent("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText((ITextProperties)showAllRecipesString, mouseX, mouseY, matrixStack);
        }
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71462_r == this) {
            if (MathUtil.contains(this.area, mouseX, mouseY)) {
                return true;
            }
            for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            IClickedIngredient<?> clicked = this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                return clicked;
            }
            if (this.func_231047_b_(mouseX, mouseY)) {
                for (RecipeLayout<?> recipeLayouts : this.recipeLayouts) {
                    Object displayedIngredient;
                    GuiIngredient<?> clicked2 = recipeLayouts.getGuiIngredientUnderMouse(mouseX, mouseY);
                    if (clicked2 == null || (displayedIngredient = clicked2.getDisplayedIngredient()) == null) continue;
                    return ClickedIngredient.create(displayedIngredient, clicked2.getRect());
                }
            }
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public boolean func_231043_a_(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = MouseUtil.getX();
        if (this.func_231047_b_(x, y = MouseUtil.getY())) {
            if (scrollDelta < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.func_231043_a_(scrollX, scrollY, scrollDelta);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
                if (this.logic.setCategoryFocus()) {
                    return true;
                }
            } else {
                for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                    if (!recipeLayout.handleClick(mouseX, mouseY, mouseButton)) continue;
                    return true;
                }
            }
        }
        if (this.recipeGuiTabs.isMouseOver(mouseX, mouseY) && this.recipeGuiTabs.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
        if (this.handleKeybindings(input)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        return this.handleKeybindings(input);
    }

    private boolean handleKeybindings(InputMappings.Input input) {
        IngredientListOverlay itemListOverlay;
        if (KeyBindings.isInventoryCloseKey(input) || KeyBindings.isInventoryToggleKey(input)) {
            this.func_231175_as__();
            return true;
        }
        if (KeyBindings.recipeBack.isActiveAndMatches(input)) {
            this.back();
            return true;
        }
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null && !(itemListOverlay = runtime.getIngredientListOverlay()).isMouseOver(MouseUtil.getX(), MouseUtil.getY())) {
            if (KeyBindings.nextPage.isActiveAndMatches(input)) {
                this.logic.nextPage();
                return true;
            }
            if (KeyBindings.previousPage.isActiveAndMatches(input)) {
                this.logic.previousPage();
                return true;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return this.field_230706_i_ != null && this.field_230706_i_.field_71462_r == this;
    }

    private void open() {
        if (this.field_230706_i_ != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.field_230706_i_.field_71462_r;
            }
            this.field_230706_i_.func_147108_a((Screen)this);
        }
    }

    public void func_231164_f_() {
        if (this.isOpen() && this.field_230706_i_ != null && !this.closing) {
            if (this.parentScreen != null) {
                this.closing = true;
                this.field_230706_i_.func_147108_a(this.parentScreen);
                this.parentScreen = null;
                this.closing = false;
            }
            this.logic.clearHistory();
        }
    }

    @Override
    public <V> void show(IFocus<V> focus) {
        Focus<V> checkedFocus = Focus.check(focus);
        if (this.logic.setFocus(checkedFocus)) {
            this.open();
        }
    }

    @Override
    public void showCategories(List<ResourceLocation> recipeCategoryUids) {
        ErrorUtil.checkNotEmpty(recipeCategoryUids, "recipeCategoryUids");
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.open();
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IClickedIngredient<?> ingredient = this.getIngredientUnderMouse(MouseUtil.getX(), MouseUtil.getY());
        if (ingredient != null) {
            return ingredient.getValue();
        }
        return null;
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        int heightPerRecipe;
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        IDrawable recipeBackground = recipeCategory.getBackground();
        int x = this.area.func_199318_a();
        int y = this.area.func_199319_b();
        int width = this.area.func_199316_c();
        int height = this.area.func_199317_d();
        int availableHeight = height - this.headerHeight;
        int recipesPerPage = availableHeight / (heightPerRecipe = recipeBackground.getHeight() + 14);
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        int recipeXOffset = x + (width - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = recipeCategory.getTitle();
        int availableTitleWidth = this.titleArea.func_199316_c();
        if (this.field_230712_o_.func_78256_a(this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.field_230712_o_);
        }
        Rectangle2d titleStringArea = MathUtil.centerTextArea(this.titleArea, this.field_230712_o_, this.title);
        this.titleHoverChecker.updateBounds(titleStringArea);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts(recipeXOffset, y + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.field_230693_o_ = this.previousPage.field_230693_o_ = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_230693_o_ = this.previousRecipeCategory.field_230693_o_ = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<Object> recipeCatalysts = this.logic.getRecipeCatalysts();
        this.recipeCatalysts.updateLayout(recipeCatalysts, this);
        this.recipeGuiTabs.initLayout(this);
    }

    private void addRecipeTransferButtons(List<RecipeLayout<?>> recipeLayouts) {
        this.field_230705_e_.removeAll(this.field_230710_m_);
        this.field_230710_m_.clear();
        this.addButtons();
        if (this.field_230706_i_ == null) {
            return;
        }
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        if (player == null) {
            return;
        }
        Container container = this.getParentContainer();
        for (RecipeLayout<?> recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            if (button == null) continue;
            button.init(this.recipeTransferManager, container, (PlayerEntity)player);
            button.setOnClickHandler((arg_0, arg_1) -> this.lambda$addRecipeTransferButtons$4(container, recipeLayout, (PlayerEntity)player, arg_0, arg_1));
            this.func_230480_a_((Widget)button);
        }
    }

    @Nullable
    private Container getParentContainer() {
        if (this.parentScreen instanceof ContainerScreen) {
            return ((ContainerScreen)this.parentScreen).func_212873_a_();
        }
        return null;
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    private /* synthetic */ void lambda$addRecipeTransferButtons$4(Container container, RecipeLayout recipeLayout, PlayerEntity player, double mouseX, double mouseY) {
        boolean maxTransfer = Screen.func_231173_s_();
        if (container != null && RecipeTransferUtil.transferRecipe(this.recipeTransferManager, container, recipeLayout, player, maxTransfer)) {
            this.func_231175_as__();
        }
    }
}

