/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.vote;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.vote.GoVoteHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;

public class GoVoteIngredient {
    public static final IIngredientType<GoVoteIngredient> TYPE = () -> GoVoteIngredient.class;
    private final String displayName;
    private final List<ITextComponent> tooltip;
    private final Supplier<IDrawable> icon;
    private final String uid;
    private final String url;

    public GoVoteIngredient(Supplier<IDrawable> icon, String uid, String displayName, List<ITextComponent> tooltip, String url) {
        this.icon = icon;
        this.uid = uid;
        this.displayName = displayName;
        this.tooltip = tooltip;
        this.url = url;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUid() {
        return this.uid;
    }

    public IDrawable getIcon() {
        return this.icon.get();
    }

    public List<ITextComponent> getTooltip() {
        return this.tooltip;
    }

    public void onClick() {
        Screen currentScreen;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && (currentScreen = minecraft.field_71462_r) != null) {
            GoVoteHandler.displayOpenLinkScreen(this.url, minecraft, currentScreen);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("displayName", (Object)this.displayName).add("tooltip", this.tooltip).add("icon", this.icon).add("uid", (Object)this.uid).toString();
    }
}

