/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    private static DecimalFormat dfCommas = new DecimalFormat("##.#");

    @Override
    public String getID() {
        return "theoneprobe:entity.default";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, Entity entity, IProbeHitEntityData data) {
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IEntityDisplayOverride override : TheOneProbe.theOneProbeImp.getEntityOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, entity, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        }
        if (entity instanceof MobEntity) {
            Collection effects;
            int age;
            MobEntity livingBase = (MobEntity)entity;
            if (Tools.show(mode, config.getShowMobHealth())) {
                int health = (int)livingBase.func_110143_aJ();
                int maxHealth = (int)livingBase.func_110138_aP();
                int armor = livingBase.func_70658_aO();
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(CompoundText.createLabelInfo("Health: ", health + " / " + maxHealth));
                }
                if (armor > 0) {
                    probeInfo.progress(armor, armor, probeInfo.defaultProgressStyle().armorBar(true).showText(false).width(80).height(10));
                }
            }
            if (Tools.show(mode, config.getShowMobGrowth()) && entity instanceof AgeableEntity && (age = ((AgeableEntity)entity).func_70874_b()) < 0) {
                probeInfo.text(CompoundText.createLabelInfo("Growing time: ", age * -1 / 20 + "s"));
            }
            if (Tools.show(mode, config.getShowMobPotionEffects()) && !(effects = livingBase.func_70651_bq()).isEmpty()) {
                IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1));
                float durationFactor = 1.0f;
                for (EffectInstance effect : effects) {
                    CompoundText text = CompoundText.create().info(effect.func_76453_d());
                    Effect potion = effect.func_188419_a();
                    if (!potion.func_188408_i()) {
                        text.style(TextStyleClass.ERROR);
                    } else {
                        text.style(TextStyleClass.OK);
                    }
                    if (effect.func_76458_c() > 0) {
                        text.text(" ").info("potion.potency." + effect.func_76458_c());
                    }
                    if (effect.func_76459_b() > 20) {
                        text.text(" (" + DefaultProbeInfoEntityProvider.getPotionDurationString(effect, durationFactor) + ")");
                    }
                    vertical.text(text);
                }
            }
        } else if (entity instanceof ItemFrameEntity) {
            ItemFrameEntity itemFrame = (ItemFrameEntity)entity;
            ItemStack stack = itemFrame.func_82335_i();
            if (!stack.func_190926_b()) {
                probeInfo.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).item(stack, new ItemStyle().width(16).height(16)).text(CompoundText.create().info(stack.func_77977_a()));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(CompoundText.createLabelInfo("Rotation: ", itemFrame.func_82333_j()));
                }
            } else {
                probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Empty"));
            }
        }
        if (Tools.show(mode, config.getAnimalOwnerSetting())) {
            UUID ownerId = null;
            if (entity instanceof TameableEntity) {
                ownerId = ((TameableEntity)entity).func_184753_b();
            } else if (entity instanceof HorseEntity) {
                ownerId = ((HorseEntity)entity).func_184780_dh();
            }
            if (ownerId != null) {
                String username = UsernameCache.getLastKnownUsername((UUID)ownerId);
                if (username == null) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("Unknown owner"));
                } else {
                    probeInfo.text(CompoundText.createLabelInfo("Owned by: ", username));
                }
            } else if (entity instanceof TameableEntity) {
                probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Tameable"));
            }
        }
        if (Tools.show(mode, config.getHorseStatSetting()) && entity instanceof HorseEntity) {
            double jumpStrength = ((HorseEntity)entity).func_110215_cj();
            double jumpHeight = -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
            probeInfo.text(CompoundText.createLabelInfo("Jump height: ", dfCommas.format(jumpHeight)));
            ModifiableAttributeInstance iattributeinstance = ((HorseEntity)entity).func_110148_a(Attributes.field_233821_d_);
            probeInfo.text(CompoundText.createLabelInfo("Speed: ", dfCommas.format(iattributeinstance.func_111126_e())));
        }
        if (entity instanceof WolfEntity && ((Boolean)Config.showCollarColor.get()).booleanValue() && ((WolfEntity)entity).func_70909_n()) {
            DyeColor collarColor = ((WolfEntity)entity).func_175546_cu();
            probeInfo.text(CompoundText.createLabelInfo("Collar: ", collarColor.func_176610_l()));
        }
    }

    public static String getPotionDurationString(EffectInstance effect, float factor) {
        if (effect.func_76459_b() == Short.MAX_VALUE) {
            return "**:**";
        }
        int i = MathHelper.func_76141_d((float)((float)effect.func_76459_b() * factor));
        return DefaultProbeInfoEntityProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, Entity entity, IProbeConfig config) {
        String modid = Tools.getModName(entity);
        if (Tools.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text(CompoundText.create().name(entity.func_200200_C_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modid));
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text(CompoundText.create().name(entity.func_200200_C_()));
        }
    }
}

