/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache.chemical;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.chemical.ChemicalToChemicalRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull STACK> outputHandler;
    private final IInputHandler<@NonNull STACK> inputHandler;

    public ChemicalToChemicalCachedRecipe(RECIPE recipe, IInputHandler<@NonNull STACK> inputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ChemicalStack recipeInput = (ChemicalStack)this.inputHandler.getRecipeInput((InputIngredient<STACK>)((ChemicalToChemicalRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport((InputIngredient<STACK>)((ChemicalToChemicalRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ChemicalToChemicalRecipe)this.recipe).getOutput(recipeInput), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ChemicalToChemicalRecipe)this.recipe).test((ChemicalStack)this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ChemicalStack recipeInput = (ChemicalStack)this.inputHandler.getRecipeInput((InputIngredient<STACK>)((ChemicalToChemicalRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return;
        }
        this.inputHandler.use(recipeInput, operations);
        this.outputHandler.handleOutput(((ChemicalToChemicalRecipe)this.recipe).getOutput(recipeInput), operations);
    }
}

