/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs.chemical;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.inputs.TagResolverHelper;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientInfo;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;

public interface ChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends IChemicalStackIngredient<CHEMICAL, STACK> {

    public static abstract class MultiIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>>
    implements ChemicalStackIngredient<CHEMICAL, STACK> {
        private final INGREDIENT[] ingredients;

        @SafeVarargs
        protected MultiIngredient(INGREDIENT ... ingredients) {
            this.ingredients = ingredients;
        }

        List<INGREDIENT> getIngredients() {
            return Arrays.asList(this.ingredients);
        }

        @Override
        public boolean test(@Nonnull STACK stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testType(@Nonnull STACK stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        public boolean testType(@Nonnull CHEMICAL chemical) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(chemical));
        }

        @Override
        @Nonnull
        public STACK getMatchingInstance(@Nonnull STACK stack) {
            for (INGREDIENT ingredient : this.ingredients) {
                ChemicalStack matchingInstance = (ChemicalStack)ingredient.getMatchingInstance(stack);
                if (matchingInstance.isEmpty()) continue;
                return (STACK)matchingInstance;
            }
            return this.getIngredientInfo().getEmptyStack();
        }

        @Override
        @Nonnull
        public List<@NonNull STACK> getRepresentations() {
            ArrayList<@NonNull TYPE> representations = new ArrayList();
            for (INGREDIENT ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)ChemicalIngredientDeserializer.IngredientType.MULTI);
            buffer.func_150787_b(this.ingredients.length);
            for (INGREDIENT ingredient : this.ingredients) {
                ingredient.write(buffer);
            }
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (INGREDIENT ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }
    }

    public static abstract class TaggedIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
    implements ChemicalStackIngredient<CHEMICAL, STACK> {
        @Nonnull
        private final ITag<CHEMICAL> tag;
        private final long amount;

        public TaggedIngredient(@Nonnull ITag<CHEMICAL> tag, long amount) {
            this.tag = tag;
            this.amount = amount;
        }

        @Override
        public boolean test(@Nonnull STACK chemicalStack) {
            return this.testType((CHEMICAL)chemicalStack) && ((ChemicalStack)chemicalStack).getAmount() >= this.amount;
        }

        @Override
        public boolean testType(@Nonnull STACK chemicalStack) {
            return this.testType((CHEMICAL)((ChemicalStack)Objects.requireNonNull(chemicalStack)).getType());
        }

        @Override
        public boolean testType(@Nonnull CHEMICAL chemical) {
            return ((Chemical)Objects.requireNonNull(chemical)).isIn(this.tag);
        }

        @Override
        @Nonnull
        public STACK getMatchingInstance(@Nonnull STACK chemicalStack) {
            if (this.test(chemicalStack)) {
                return this.getIngredientInfo().createStack(chemicalStack, this.amount);
            }
            return this.getIngredientInfo().getEmptyStack();
        }

        @Override
        @Nonnull
        public List<@NonNull STACK> getRepresentations() {
            ChemicalIngredientInfo ingredientInfo = this.getIngredientInfo();
            ArrayList<@NonNull Chemical> representations = new ArrayList<Chemical>();
            for (Chemical chemical : TagResolverHelper.getRepresentations(this.tag)) {
                representations.add(ingredientInfo.createStack(chemical, this.amount));
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)ChemicalIngredientDeserializer.IngredientType.TAGGED);
            buffer.func_192572_a(this.getIngredientInfo().getTagLocation(this.tag));
            buffer.func_179254_b(this.amount);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.amount);
            json.addProperty("tag", this.getIngredientInfo().getTagLocation(this.tag).toString());
            return json;
        }
    }

    public static abstract class SingleIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
    implements ChemicalStackIngredient<CHEMICAL, STACK> {
        @Nonnull
        private final STACK chemicalInstance;

        public SingleIngredient(@Nonnull STACK chemicalInstance) {
            this.chemicalInstance = chemicalInstance;
        }

        @Override
        public boolean test(@Nonnull STACK chemicalStack) {
            return this.testType((CHEMICAL)chemicalStack) && ((ChemicalStack)chemicalStack).getAmount() >= ((ChemicalStack)this.chemicalInstance).getAmount();
        }

        @Override
        public boolean testType(@Nonnull STACK chemicalStack) {
            return ((ChemicalStack)this.chemicalInstance).isTypeEqual((ChemicalStack)((ChemicalStack)Objects.requireNonNull(chemicalStack)));
        }

        @Override
        public boolean testType(@Nonnull CHEMICAL chemical) {
            return ((ChemicalStack)this.chemicalInstance).isTypeEqual((Chemical)((Chemical)Objects.requireNonNull(chemical)));
        }

        @Override
        @Nonnull
        public STACK getMatchingInstance(@Nonnull STACK chemicalStack) {
            if (this.test(chemicalStack)) {
                return this.getIngredientInfo().createStack(this.chemicalInstance, ((ChemicalStack)this.chemicalInstance).getAmount());
            }
            return this.getIngredientInfo().getEmptyStack();
        }

        @Override
        @Nonnull
        public List<@NonNull STACK> getRepresentations() {
            return Collections.singletonList(this.chemicalInstance);
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)ChemicalIngredientDeserializer.IngredientType.SINGLE);
            ((ChemicalStack)this.chemicalInstance).writeToPacket(buffer);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)((ChemicalStack)this.chemicalInstance).getAmount());
            json.addProperty(this.getIngredientInfo().getSerializationKey(), ((ChemicalStack)this.chemicalInstance).getTypeRegistryName().toString());
            return json;
        }
    }
}

