/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SparkleAnimation {
    private final TileEntity tile;
    private final BlockPos corner1;
    private final BlockPos corner2;

    public SparkleAnimation(TileEntity tile, BlockPos corner1, BlockPos corner2) {
        this.tile = tile;
        this.corner1 = corner1;
        this.corner2 = corner2;
    }

    public SparkleAnimation(TileEntity tile, BlockPos renderLoc, int length, int width, int height) {
        this(tile, new BlockPos(renderLoc.func_177958_n(), renderLoc.func_177956_o() - 1, renderLoc.func_177952_p()), new BlockPos(renderLoc.func_177958_n() + length, renderLoc.func_177956_o() + height - 1, renderLoc.func_177952_p() + width));
    }

    public void run() {
        Vector3d origin;
        World world = this.tile.func_145831_w();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int xSize = this.corner2.func_177958_n() - this.corner1.func_177958_n() + 1;
        int ySize = this.corner2.func_177956_o() - this.corner1.func_177956_o() + 1;
        int zSize = this.corner2.func_177952_p() - this.corner1.func_177952_p() + 1;
        Vector3d displacement = origin = new Vector3d((double)xSize / 2.0, (double)ySize / 2.0, (double)zSize / 2.0);
        this.sparkleSide(world, random, origin, displacement, xSize, ySize, 0.0f, 0.0f);
        this.sparkleSide(world, random, origin, displacement, xSize, ySize, (float)Math.PI, 0.0f);
        displacement = new Vector3d(origin.field_72449_c, origin.field_72448_b, origin.field_72450_a);
        this.sparkleSide(world, random, origin, displacement, zSize, ySize, 1.5707964f, 0.0f);
        this.sparkleSide(world, random, origin, displacement, zSize, ySize, 4.712389f, 0.0f);
        displacement = new Vector3d(origin.field_72450_a, origin.field_72449_c, origin.field_72448_b);
        this.sparkleSide(world, random, origin, displacement, xSize, zSize, 0.0f, 1.5707964f);
        this.sparkleSide(world, random, origin, displacement, xSize, zSize, 0.0f, 4.712389f);
    }

    private void sparkleSide(World world, Random random, Vector3d origin, Vector3d displacement, int width, int height, float rotationYaw, float rotationPitch) {
        for (int i = 0; i < 100; ++i) {
            Vector3d pos = new Vector3d((double)width * random.nextDouble(), (double)height * random.nextDouble(), -0.01).func_178788_d(displacement);
            pos = pos.func_178785_b(rotationYaw).func_178789_a(rotationPitch);
            pos = pos.func_178787_e(origin).func_72441_c((double)this.corner1.func_177958_n(), (double)this.corner1.func_177956_o(), (double)this.corner1.func_177952_p());
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 0.0, 0.0, 0.0);
        }
    }
}

