/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiBoilerStats
extends GuiMekanismTile<TileEntityBoilerCasing, EmptyTileContainer<TileEntityBoilerCasing>> {
    private GuiGraph boilGraph;
    private GuiGraph maxGraph;

    public GuiBoilerStats(EmptyTileContainer<TileEntityBoilerCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tile, GuiBoilerTab.BoilerTab.MAIN));
        this.func_230480_a_(new GuiHeatTab(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
        this.boilGraph = new GuiGraph((IGuiWrapper)this, 8, 83, 160, 36, xva$0 -> MekanismLang.BOIL_RATE.translate(xva$0));
        this.func_230480_a_(this.boilGraph);
        this.maxGraph = new GuiGraph((IGuiWrapper)this, 8, 122, 160, 36, xva$0 -> MekanismLang.MAX_BOIL_RATE.translate(xva$0));
        this.func_230480_a_(this.maxGraph);
        this.maxGraph.enableFixedScale((long)(MekanismConfig.general.superheatingHeatTransfer.get() * (double)((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).superheatingElements / HeatUtils.getWaterThermalEnthalpy()));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawCenteredText(matrix, (ITextComponent)MekanismLang.BOILER_STATS.translate(new Object[0]), 0.0f, this.field_146999_f, this.field_238743_q_, this.titleTextColor());
        BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock();
        this.drawString(matrix, (ITextComponent)MekanismLang.BOILER_MAX_WATER.translate(GuiBoilerStats.formatInt(multiblock.waterTank.getCapacity())), 8, 26, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.BOILER_MAX_STEAM.translate(GuiBoilerStats.formatInt(multiblock.steamTank.getCapacity())), 8, 35, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.BOILER_HEAT_TRANSFER.translate(new Object[0]), 8, 49, this.subheadingTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.BOILER_HEATERS.translate(multiblock.superheatingElements), 14, 58, this.titleTextColor());
        double boilCapacity = MekanismConfig.general.superheatingHeatTransfer.get() * (double)multiblock.superheatingElements / HeatUtils.getWaterThermalEnthalpy();
        this.drawString(matrix, (ITextComponent)MekanismLang.BOILER_CAPACITY.translate(GuiBoilerStats.formatInt((long)(boilCapacity *= HeatUtils.getSteamEnergyEfficiency()))), 8, 72, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock();
        this.boilGraph.addData(multiblock.lastBoilRate);
        this.maxGraph.addData(multiblock.lastMaxBoil);
    }
}

