/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.IDisableableEnum;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.item.interfaces.IRadialSelectorEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class GuiRadialSelector<TYPE extends Enum<TYPE>>
extends Screen {
    private static final float DRAWS = 300.0f;
    private static final float INNER = 40.0f;
    private static final float OUTER = 100.0f;
    private static final float SELECT_RADIUS = 10.0f;
    private final Class<TYPE> enumClass;
    private final TYPE[] types;
    private final Supplier<TYPE> curSupplier;
    private final Consumer<TYPE> changeHandler;
    private final boolean isDisableable;
    private TYPE selection = null;

    public GuiRadialSelector(Class<TYPE> enumClass, Supplier<TYPE> curSupplier, Consumer<TYPE> changeHandler) {
        super((ITextComponent)new StringTextComponent("Radial Selector Screen"));
        this.enumClass = enumClass;
        this.curSupplier = curSupplier;
        this.changeHandler = changeHandler;
        this.isDisableable = IDisableableEnum.class.isAssignableFrom(enumClass);
        this.types = (Enum[])enumClass.getEnumConstants();
    }

    public void func_230430_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTick) {
        float centerX = (float)Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2.0f;
        float centerY = (float)Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2.0f;
        matrix.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        matrix.func_227861_a_((double)centerX, (double)centerY, 0.0);
        RenderSystem.disableTexture();
        int activeModes = this.isDisableable ? (int)Arrays.stream(this.types).filter(type -> ((IDisableableEnum)((Object)type)).isEnabled()).count() : this.types.length;
        RenderSystem.color4f((float)0.3f, (float)0.3f, (float)0.3f, (float)0.5f);
        this.drawTorus(matrix, 0.0f, 360.0f);
        Enum cur = (Enum)this.curSupplier.get();
        if (cur != null) {
            int section;
            if (((IRadialSelectorEnum)((Object)cur)).getColor() == null) {
                RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)0.7f);
            } else {
                MekanismRenderer.color(((IRadialSelectorEnum)((Object)cur)).getColor(), 0.3f);
            }
            if (this.isDisableable) {
                section = 0;
                for (TYPE type2 : this.types) {
                    if (!((IDisableableEnum)type2).isEnabled()) continue;
                    if (type2 != cur) {
                        ++section;
                        continue;
                    }
                    break;
                }
            } else {
                section = cur.ordinal();
            }
            this.drawTorus(matrix, -90.0f + 360.0f * (-0.5f + (float)section) / (float)activeModes, 360.0f / (float)activeModes);
            double xDiff = (float)mouseX - centerX;
            double yDiff = (float)mouseY - centerY;
            if (Math.sqrt(xDiff * xDiff + yDiff * yDiff) >= 10.0) {
                float selectionAngle;
                float angle = (float)Math.toDegrees(Math.atan2(yDiff, xDiff));
                RenderSystem.color4f((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
                this.drawTorus(matrix, 360.0f * (-0.5f / (float)activeModes) + angle, 360.0f / (float)activeModes);
                for (selectionAngle = angle + 90.0f + 360.0f * (0.5f / (float)activeModes); selectionAngle < 0.0f; selectionAngle += 360.0f) {
                }
                int selectionDrawnPos = (int)(selectionAngle * ((float)activeModes / 360.0f));
                if (this.isDisableable) {
                    int count = 0;
                    for (TYPE type3 : this.types) {
                        if (!((IDisableableEnum)type3).isEnabled()) continue;
                        if (count == selectionDrawnPos) {
                            this.selection = type3;
                            break;
                        }
                        ++count;
                    }
                } else {
                    this.selection = this.types[selectionDrawnPos];
                }
                RenderSystem.color4f((float)0.6f, (float)0.6f, (float)0.6f, (float)0.7f);
                this.drawTorus(matrix, -90.0f + 360.0f * (-0.5f + (float)selectionDrawnPos) / (float)activeModes, 360.0f / (float)activeModes);
            } else {
                this.selection = null;
            }
        }
        MekanismRenderer.resetColor();
        RenderSystem.enableTexture();
        int position = 0;
        for (TYPE type2 : this.types) {
            if (this.isDisableable && !((IDisableableEnum)type2).isEnabled()) continue;
            double angle = Math.toRadians(270.0f + 360.0f * ((float)position / (float)activeModes));
            float x = (float)Math.cos(angle) * 140.0f / 2.0f;
            float y = (float)Math.sin(angle) * 140.0f / 2.0f;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(((IRadialSelectorEnum)type2).getIcon());
            GuiRadialSelector.func_238466_a_((MatrixStack)matrix, (int)Math.round(x - 12.0f), (int)Math.round(y - 20.0f), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            matrix.func_227860_a_();
            int width = this.field_230712_o_.func_238414_a_((ITextProperties)((IRadialSelectorEnum)type2).getShortText());
            matrix.func_227861_a_((double)x, (double)y, 0.0);
            matrix.func_227862_a_(0.6f, 0.6f, 0.6f);
            this.field_230712_o_.func_243248_b(matrix, ((IRadialSelectorEnum)type2).getShortText(), (float)(-width) / 2.0f, 8.0f, -855638017);
            matrix.func_227865_b_();
            ++position;
        }
        MekanismRenderer.resetColor();
        matrix.func_227865_b_();
    }

    public void func_231164_f_() {
        this.updateSelection();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.updateSelection();
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void drawTorus(MatrixStack matrix, float startAngle, float sizeAngle) {
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        vertexBuffer.func_181668_a(8, DefaultVertexFormats.field_181705_e);
        float draws = 300.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float angle = (float)Math.toRadians(startAngle + (float)i / 300.0f * 360.0f);
            vertexBuffer.func_227888_a_(matrix4f, (float)(100.0 * Math.cos(angle)), (float)(100.0 * Math.sin(angle)), 0.0f).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, (float)(40.0 * Math.cos(angle)), (float)(40.0 * Math.sin(angle)), 0.0f).func_181675_d();
            ++i;
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
    }

    public void updateSelection() {
        if (this.selection != null) {
            this.changeHandler.accept(this.selection);
        }
    }

    public Class<TYPE> getEnumClass() {
        return this.enumClass;
    }
}

