/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.custom.GuiTeleporterStatus;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketGuiSetFrequency;
import mekanism.common.network.PacketTeleporterSetColor;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiTeleporter
extends GuiMekanismTile<TileEntityTeleporter, MekanismTileContainer<TileEntityTeleporter>> {
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton setButton;
    private MekanismButton deleteButton;
    private GuiTextScrollList scrollList;
    private GuiTextField frequencyField;
    private boolean privateMode;
    private boolean init = false;

    public GuiTeleporter(MekanismTileContainer<TileEntityTeleporter> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        TeleporterFrequency teleporterFrequency = (TeleporterFrequency)((TileEntityTeleporter)this.tile).getFrequency(FrequencyType.TELEPORTER);
        if (teleporterFrequency != null) {
            this.privateMode = teleporterFrequency.isPrivate();
        }
        this.field_147000_g += 64;
        this.field_238743_q_ = 4;
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiTeleporterStatus(this, () -> ((TileEntityTeleporter)this.tile).getFrequency(FrequencyType.TELEPORTER) != null, () -> ((TileEntityTeleporter)this.tile).status));
        this.func_230480_a_(new GuiRedstoneControlTab(this, this.tile));
        this.func_230480_a_(new GuiUpgradeTab(this, this.tile));
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, this.tile));
        this.func_230480_a_(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityTeleporter)this.tile).getEnergyContainer(), 158, 26));
        this.scrollList = new GuiTextScrollList(this, 27, 36, 122, 42);
        this.func_230480_a_(this.scrollList);
        this.publicButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 14, 60, 20, MekanismLang.PUBLIC, () -> {
            this.privateMode = false;
            this.updateButtons();
        });
        this.func_230480_a_(this.publicButton);
        this.privateButton = new TranslationButton(this, this.field_147003_i + 89, this.field_147009_r + 14, 60, 20, MekanismLang.PRIVATE, () -> {
            this.privateMode = true;
            this.updateButtons();
        });
        this.func_230480_a_(this.privateButton);
        this.setButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 120, 50, 18, MekanismLang.BUTTON_SET, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? (Frequency)((TileEntityTeleporter)this.tile).getPrivateCache(FrequencyType.TELEPORTER).get(selection) : (Frequency)((TileEntityTeleporter)this.tile).getPublicCache(FrequencyType.TELEPORTER).get(selection);
                this.setFrequency(freq.getName());
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.setButton);
        this.deleteButton = new TranslationButton(this, this.field_147003_i + 79, this.field_147009_r + 120, 50, 18, MekanismLang.BUTTON_DELETE, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? (Frequency)((TileEntityTeleporter)this.tile).getPrivateCache(FrequencyType.TELEPORTER).get(selection) : (Frequency)((TileEntityTeleporter)this.tile).getPublicCache(FrequencyType.TELEPORTER).get(selection);
                Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.REMOVE_TILE, FrequencyType.TELEPORTER, freq.getIdentity(), ((TileEntityTeleporter)this.tile).func_174877_v()));
                this.scrollList.clearSelection();
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.deleteButton);
        this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, 131, 120).setRenderAboveSlots());
        this.func_230480_a_(new ColorButton((IGuiWrapper)this, this.field_147003_i + 132, this.field_147009_r + 121, 16, 16, () -> {
            TeleporterFrequency frequency = this.getFrequency();
            return frequency == null ? null : frequency.getColor();
        }, () -> this.sendColorUpdate(0), () -> this.sendColorUpdate(1)));
        this.frequencyField = new GuiTextField(this, 50, 103, 98, 11);
        this.func_230480_a_(this.frequencyField);
        this.frequencyField.setMaxStringLength(16);
        this.frequencyField.setBackground(BackgroundType.INNER_SCREEN);
        this.frequencyField.setEnterHandler(this::setFrequency);
        this.frequencyField.setInputValidator(InputValidator.or(InputValidator.DIGIT, InputValidator.LETTER, InputValidator.FREQUENCY_CHARS));
        this.frequencyField.addCheckmarkButton(this::setFrequency);
        this.updateButtons();
    }

    public ITextComponent getSecurity(Frequency freq) {
        if (freq.isPublic()) {
            return MekanismLang.PUBLIC.translate(new Object[0]);
        }
        return MekanismLang.PRIVATE.translateColored(EnumColor.DARK_RED, new Object[0]);
    }

    private void updateButtons() {
        if (((TileEntityTeleporter)this.tile).getOwnerUUID() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : ((TileEntityTeleporter)this.tile).getPrivateCache(FrequencyType.TELEPORTER)) {
                text.add(freq.getName());
            }
        } else {
            for (Frequency freq : ((TileEntityTeleporter)this.tile).getPublicCache(FrequencyType.TELEPORTER)) {
                text.add(MekanismLang.GENERIC_WITH_PARENTHESIS.translate(freq.getName(), freq.getClientOwner()).getString());
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_230693_o_ = true;
            this.privateButton.field_230693_o_ = false;
        } else {
            this.publicButton.field_230693_o_ = false;
            this.privateButton.field_230693_o_ = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? (Frequency)((TileEntityTeleporter)this.tile).getPrivateCache(FrequencyType.TELEPORTER).get(this.scrollList.getSelection()) : (Frequency)((TileEntityTeleporter)this.tile).getPublicCache(FrequencyType.TELEPORTER).get(this.scrollList.getSelection());
            TeleporterFrequency teleporterFrequency = (TeleporterFrequency)((TileEntityTeleporter)this.tile).getFrequency(FrequencyType.TELEPORTER);
            this.setButton.field_230693_o_ = teleporterFrequency == null || !teleporterFrequency.equals(freq);
            this.deleteButton.field_230693_o_ = ((TileEntityTeleporter)this.tile).getOwnerUUID().equals(freq.getOwner());
        } else {
            this.setButton.field_230693_o_ = false;
            this.deleteButton.field_230693_o_ = false;
        }
    }

    @Override
    public void func_231023_e_() {
        TeleporterFrequency frequency;
        super.func_231023_e_();
        if (!this.init && (frequency = this.getFrequency()) != null) {
            this.init = true;
            this.privateMode = frequency.isPrivate();
        }
        this.updateButtons();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setFrequency() {
        this.setFrequency(this.frequencyField.getText());
        this.frequencyField.setText("");
        this.updateButtons();
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, OwnerDisplay.of(((TileEntityTeleporter)this.tile).getOwnerUUID(), ((TileEntityTeleporter)this.tile).getOwnerName()).getTextComponent(), 8, this.field_147000_g - 92, this.titleTextColor());
        TranslationTextComponent frequencyComponent = MekanismLang.FREQUENCY.translate(new Object[0]);
        this.drawString(matrix, (ITextComponent)frequencyComponent, 32, 81, this.titleTextColor());
        TranslationTextComponent securityComponent = MekanismLang.SECURITY.translate("");
        this.drawString(matrix, (ITextComponent)securityComponent, 32, 91, this.titleTextColor());
        Frequency freq = ((TileEntityTeleporter)this.tile).getFrequency(FrequencyType.TELEPORTER);
        int frequencyOffset = this.getStringWidth((ITextComponent)frequencyComponent) + 1;
        if (freq == null) {
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + frequencyOffset, 81, this.subheadingTextColor());
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, this.subheadingTextColor());
        } else {
            this.drawTextScaledBound(matrix, freq.getName(), 32 + frequencyOffset, 81.0f, this.subheadingTextColor(), this.field_146999_f - 32 - frequencyOffset - 4);
            this.drawString(matrix, this.getSecurity(freq), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, this.subheadingTextColor());
        }
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.SET.translate(new Object[0]), 27.0f, 104.0f, this.titleTextColor(), 20.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    public void setFrequency(String freq) {
        if (!freq.isEmpty()) {
            Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.SET_TILE, FrequencyType.TELEPORTER, new Frequency.FrequencyIdentity(freq, !this.privateMode), ((TileEntityTeleporter)this.tile).func_174877_v()));
        }
    }

    public TeleporterFrequency getFrequency() {
        return (TeleporterFrequency)((TileEntityTeleporter)this.tile).getFrequency(FrequencyType.TELEPORTER);
    }

    private void sendColorUpdate(int extra) {
        TeleporterFrequency freq = this.getFrequency();
        if (freq != null) {
            Mekanism.packetHandler.sendToServer(PacketTeleporterSetColor.create(((TileEntityTeleporter)this.tile).getTilePos(), freq, extra));
        }
    }
}

