/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.MekanismLang;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public class GuiDigitalSwitch
extends GuiTexturedElement {
    public static final ResourceLocation SWITCH = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/switch.png");
    public static final int BUTTON_SIZE_X = 15;
    public static final int BUTTON_SIZE_Y = 8;
    private final SwitchType type;
    private final ResourceLocation icon;
    private final BooleanSupplier stateSupplier;
    private final ITextComponent tooltip;
    private final Runnable onToggle;

    public GuiDigitalSwitch(IGuiWrapper gui, int x, int y, ResourceLocation icon, BooleanSupplier stateSupplier, ITextComponent tooltip, Runnable onToggle, SwitchType type) {
        super(SWITCH, gui, x, y, type.sizeX, type.sizeY);
        this.type = type;
        this.icon = icon;
        this.stateSupplier = stateSupplier;
        this.tooltip = tooltip;
        this.onToggle = onToggle;
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.displayTooltip(matrix, this.tooltip, mouseX, mouseY);
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GuiDigitalSwitch.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiDigitalSwitch.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + this.type.switchX), (int)(this.field_230691_m_ + this.type.switchY), (float)0.0f, (float)(this.stateSupplier.getAsBoolean() ? 0.0f : 8.0f), (int)15, (int)8, (int)15, (int)16);
        GuiDigitalSwitch.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + this.type.switchX), (int)(this.field_230691_m_ + this.type.switchY + 8 + 1), (float)0.0f, (float)(this.stateSupplier.getAsBoolean() ? 8.0f : 0.0f), (int)15, (int)8, (int)15, (int)16);
        GuiDigitalSwitch.minecraft.field_71446_o.func_110577_a(this.icon);
        GuiDigitalSwitch.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 6), (int)(this.field_230691_m_ + 21), (float)0.0f, (float)0.0f, (int)5, (int)5, (int)5, (int)5);
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawScaledCenteredText(matrix, (ITextComponent)MekanismLang.ON.translate(new Object[0]), this.relativeX + 8, this.relativeY + 1, 0x101010, 0.5f);
        this.drawScaledCenteredText(matrix, (ITextComponent)MekanismLang.OFF.translate(new Object[0]), this.relativeX + 8, this.relativeY + 10, 0x101010, 0.5f);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
        this.onToggle.run();
    }

    public static enum SwitchType {
        LOWER_ICON(15, 40, 0, 0);

        private final int sizeX;
        private final int sizeY;
        private final int switchX;
        private final int switchY;

        private SwitchType(int sizeX, int sizeY, int switchX, int switchY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.switchX = switchX;
            this.switchY = switchY;
        }
    }
}

