/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public class GuiDropdown<TYPE extends Enum<TYPE>>
extends GuiTexturedElement {
    private final Consumer<TYPE> handler;
    private final Supplier<TYPE> curType;
    private final TYPE[] options;
    private boolean isOpen;
    private boolean isHolding;

    public GuiDropdown(IGuiWrapper gui, int x, int y, int width, Class<TYPE> enumClass, Supplier<TYPE> curType, Consumer<TYPE> handler) {
        super(GuiInnerScreen.SCREEN, gui, x, y, width, 12);
        this.curType = curType;
        this.handler = handler;
        this.options = (Enum[])enumClass.getEnumConstants();
        this.field_230693_o_ = true;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        this.isHolding = true;
        this.setOpen(!this.isOpen || mouseY > (double)(this.field_230691_m_ + 11));
        minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
    }

    @Override
    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_231000_a__(mouseX, mouseY);
        if (this.isHolding) {
            this.isHolding = false;
            if (this.isOpen && mouseY > (double)(this.field_230691_m_ + 11)) {
                this.handler.accept(this.options[this.getHoveredIndex(mouseX, mouseY)]);
                this.setOpen(false);
            }
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        int maxWidth = this.field_230688_j_ - 11;
        Enum current = (Enum)this.curType.get();
        this.drawScaledTextScaledBound(matrix, ((GuiComponents.IDropdownEnum)((Object)current)).getShortName(), this.relativeX + 4, this.relativeY + 2, this.screenTextColor(), maxWidth, 0.8f);
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                this.drawScaledTextScaledBound(matrix, ((GuiComponents.IDropdownEnum)this.options[i]).getShortName(), this.relativeX + 4, this.relativeY + 11 + 2 + 10 * i, this.screenTextColor(), maxWidth, 0.8f);
            }
        }
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        Enum current;
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.0, 1.0);
        this.renderBackgroundTexture(matrix, this.getResource(), 4, 4);
        int index = this.getHoveredIndex(mouseX, mouseY);
        if (index != -1) {
            GuiUtils.drawOutline(matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 12 + index * 10, this.field_230688_j_ - 2, 10, this.screenTextColor());
        }
        if (((GuiComponents.IDropdownEnum)((Object)(current = (Enum)this.curType.get()))).getIcon() != null) {
            GuiDropdown.minecraft.field_71446_o.func_110577_a(((GuiComponents.IDropdownEnum)((Object)current)).getIcon());
            GuiDropdown.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + this.field_230688_j_ - 9), (int)(this.field_230691_m_ + 3), (float)0.0f, (float)0.0f, (int)6, (int)6, (int)6, (int)6);
        }
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                ResourceLocation icon = ((GuiComponents.IDropdownEnum)this.options[i]).getIcon();
                if (icon == null) continue;
                GuiDropdown.minecraft.field_71446_o.func_110577_a(icon);
                GuiDropdown.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + this.field_230688_j_ - 9), (int)(this.field_230691_m_ + 12 + 2 + 10 * i), (float)0.0f, (float)0.0f, (int)6, (int)6, (int)6, (int)6);
            }
        }
        matrix.func_227865_b_();
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        ITextComponent text;
        int index = this.getHoveredIndex(mouseX + this.guiObj.getLeft(), mouseY + this.guiObj.getTop());
        if (index != -1 && (text = ((GuiComponents.IDropdownEnum)this.options[index]).getTooltip()) != null) {
            this.displayTooltip(matrix, ((GuiComponents.IDropdownEnum)this.options[index]).getTooltip(), mouseX, mouseY);
        }
    }

    private int getHoveredIndex(double mouseX, double mouseY) {
        if (this.isOpen && mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)(this.field_230691_m_ + 11) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_)) {
            return Math.max(0, Math.min(this.options.length - 1, (int)((mouseY - (double)this.field_230691_m_ - 11.0) / 10.0)));
        }
        return -1;
    }

    private void setOpen(boolean open) {
        if (this.isOpen != open) {
            this.field_230689_k_ = open ? (this.field_230689_k_ += this.options.length * 10 + 1) : (this.field_230689_k_ -= this.options.length * 10 + 1);
        }
        this.isOpen = open;
    }
}

