/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiWindow;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.tab.GuiConfigTypeTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiSideConfiguration
extends GuiWindow {
    private final List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();
    private final TileEntityMekanism tile;
    private TransmissionType currentType;

    public GuiSideConfiguration(IGuiWrapper gui, int x, int y, TileEntityMekanism tile) {
        super(gui, x, y, 156, 115);
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        this.currentType = this.getTopTransmission();
        this.addChild(new GuiInnerScreen(gui, this.relativeX + 41, this.relativeY + 25, 74, 12));
        List<TransmissionType> transmissions = ((ISideConfiguration)this.getTile()).getConfig().getTransmissions();
        for (int i = 0; i < transmissions.size(); ++i) {
            GuiConfigTypeTab tab = new GuiConfigTypeTab(gui, transmissions.get(i), this.relativeX + (i < 4 ? -26 : this.field_230688_j_), this.relativeY + (2 + 28 * (i % 4)), this, i < 4);
            this.addChild(tab);
            this.configTabs.add(tab);
        }
        this.updateTabs();
        this.addChild(new MekanismImageButton(gui, gui.getLeft() + this.relativeX + 136, gui.getTop() + this.relativeY + 6, 14, this.getButtonLocation("auto_eject"), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(tile.func_174877_v(), this.currentType)), this.getOnHover(MekanismLang.AUTO_EJECT)));
        this.addSideDataButton(RelativeSide.BOTTOM, 71, 74);
        this.addSideDataButton(RelativeSide.TOP, 71, 44);
        this.addSideDataButton(RelativeSide.FRONT, 71, 59);
        this.addSideDataButton(RelativeSide.BACK, 56, 74);
        this.addSideDataButton(RelativeSide.LEFT, 56, 59);
        this.addSideDataButton(RelativeSide.RIGHT, 86, 59);
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_SIDE_CONFIG, (TileEntity)tile, 1));
        ((MekanismContainer)((GuiMekanism)this.guiObj).func_212873_a_()).startTracking(1, ((ISideConfiguration)((Object)tile)).getConfig());
    }

    private void addSideDataButton(RelativeSide side, int xPos, int yPos) {
        this.addChild(new SideDataButton(this.guiObj, this.guiObj.getLeft() + this.relativeX + xPos, this.guiObj.getTop() + this.relativeY + yPos, side, () -> ((ISideConfiguration)this.getTile()).getConfig().getDataType(this.currentType, side), () -> {
            DataType dataType = ((ISideConfiguration)this.getTile()).getConfig().getDataType(this.currentType, side);
            return dataType == null ? EnumColor.GRAY : dataType.getColor();
        }, this.tile, () -> this.currentType, PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, this.getOnHover(side)));
    }

    @Override
    public void close() {
        super.close();
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (TileEntity)this.tile, 1));
        ((MekanismContainer)((GuiMekanism)this.guiObj).func_212873_a_()).stopTracking(1);
    }

    public <TILE extends TileEntityMekanism> TILE getTile() {
        return (TILE)this.tile;
    }

    private GuiElement.IHoverable getOnHover(RelativeSide side) {
        return (onHover, matrix, xAxis, yAxis) -> {
            DataType dataType;
            if (onHover instanceof SideDataButton && (dataType = ((SideDataButton)onHover).getDataType()) != null) {
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_WITH_TWO_PARENTHESIS.translateColored(dataType.getColor(), dataType, dataType.getColor().getName(), side), xAxis, yAxis);
            }
        };
    }

    private TransmissionType getTopTransmission() {
        return ((ISideConfiguration)this.getTile()).getConfig().getTransmissions().get(0);
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    public void updateTabs() {
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.field_230694_p_ = this.currentType != tab.getTransmissionType();
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.CONFIG_TYPE.translate(this.currentType), 5.0f);
        ConfigInfo config = ((ISideConfiguration)this.getTile()).getConfig().getConfig(this.currentType);
        if (config == null || !config.canEject()) {
            this.drawString(matrix, (ITextComponent)MekanismLang.NO_EJECT.translate(new Object[0]), this.relativeX + 43, this.relativeY + 27, this.screenTextColor());
        } else {
            this.drawString(matrix, (ITextComponent)MekanismLang.EJECT.translate(BooleanStateDisplay.OnOff.of(config.isEjecting())), this.relativeX + 43, this.relativeY + 27, this.screenTextColor());
        }
        this.drawString(matrix, (ITextComponent)MekanismLang.SLOTS.translate(new Object[0]), this.relativeX + 67, this.relativeY + 96, this.subheadingTextColor());
    }
}

