/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiGauge<T>
extends GuiTexturedElement {
    private final GaugeType gaugeType;
    protected boolean dummy;
    protected T dummyType;

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y) {
        this(gaugeType, gui, x, y, gaugeType.getGaugeOverlay().getWidth() + 2, gaugeType.getGaugeOverlay().getHeight() + 2);
    }

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y, int sizeX, int sizeY) {
        super(gaugeType.getGaugeOverlay().getBarOverlay(), gui, x, y, sizeX, sizeY);
        this.gaugeType = gaugeType;
    }

    public abstract int getScaledLevel();

    public abstract TextureAtlasSprite getIcon();

    public abstract ITextComponent getLabel();

    public abstract List<ITextComponent> getTooltipText();

    protected GaugeInfo getGaugeColor() {
        return GaugeInfo.STANDARD;
    }

    protected void applyRenderColor() {
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GaugeInfo color = this.getGaugeColor();
        this.renderExtendedTexture(matrix, color.getResourceLocation(), color.getSideWidth(), color.getSideHeight());
        if (!this.dummy) {
            this.renderContents(matrix);
        }
    }

    public void renderContents(MatrixStack matrix) {
        int scale = this.getScaledLevel();
        TextureAtlasSprite icon = this.getIcon();
        if (scale > 0 && icon != null) {
            this.applyRenderColor();
            this.drawTiledSprite(matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230689_k_ - 2, this.field_230688_j_ - 2, scale, icon);
            MekanismRenderer.resetColor();
        }
        GuiGauge.minecraft.field_71446_o.func_110577_a(this.getResource());
        GaugeOverlay gaugeOverlay = this.gaugeType.getGaugeOverlay();
        GuiGauge.func_238466_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (int)(this.func_230998_h_() - 2), (int)(this.func_238483_d_() - 2), (float)0.0f, (float)0.0f, (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight(), (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight());
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        ItemStack stack = GuiGauge.minecraft.field_71439_g.field_71071_by.func_70445_o();
        EnumColor color = this.gaugeType.getGaugeInfo().getColor();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && color != null) {
            Object tile;
            if (this.guiObj instanceof GuiMekanismTile && (tile = ((GuiMekanismTile)this.guiObj).getTileEntity()) instanceof ISideConfiguration && this.getTransmission() != null) {
                DataType dataType = null;
                ConfigInfo config = ((ISideConfiguration)tile).getConfig().getConfig(this.getTransmission());
                if (config != null) {
                    Set<DataType> supportedDataTypes = config.getSupportedDataTypes();
                    for (DataType type : supportedDataTypes) {
                        if (type.getColor() != color) continue;
                        dataType = type;
                        break;
                    }
                }
                if (dataType == null) {
                    this.guiObj.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_PARENTHESIS.translateColored(color, color.getName()), mouseX, mouseY);
                } else {
                    this.guiObj.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, dataType, color.getName()), mouseX, mouseY);
                }
            }
        } else {
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            if (this.getLabel() != null) {
                list.add(this.getLabel());
            }
            list.addAll(this.getTooltipText());
            this.guiObj.displayTooltips(matrix, list, mouseX, mouseY);
        }
    }

    @Nullable
    public abstract TransmissionType getTransmission();

    public void setDummyType(T type) {
        this.dummyType = type;
    }
}

