/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mekanism.client.SpecialColors;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiRedstoneControlTab
extends GuiInsetElement<TileEntityMekanism> {
    private static final ResourceLocation DISABLED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_disabled.png");
    private static final ResourceLocation HIGH = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_high.png");
    private static final ResourceLocation LOW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_low.png");
    private static final ResourceLocation PULSE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_pulse.png");

    public GuiRedstoneControlTab(IGuiWrapper gui, TileEntityMekanism tile) {
        super(DISABLED, gui, tile, gui.getWidth(), 137, 26, 18, false);
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.displayTooltip(matrix, ((TileEntityMekanism)this.dataSource).getControlType().getTextComponent(), mouseX, mouseY);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_REDSTONE_CONTROL, (TileEntity)this.dataSource));
    }

    @Override
    protected ResourceLocation getOverlay() {
        switch (((TileEntityMekanism)this.dataSource).getControlType()) {
            case HIGH: {
                return HIGH;
            }
            case LOW: {
                return LOW;
            }
            case PULSE: {
                return PULSE;
            }
        }
        return super.getOverlay();
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_REDSTONE_CONTROL);
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        if (((TileEntityMekanism)this.dataSource).getControlType() == IRedstoneControl.RedstoneControl.PULSE) {
            this.drawButton(matrix, mouseX, mouseY);
            GuiRedstoneControlTab.minecraft.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            GuiUtils.drawSprite(matrix, this.getButtonX() + 1, this.getButtonY() + 1, this.innerWidth - 2, this.innerHeight - 2, 0, MekanismRenderer.redstonePulse);
        }
    }
}

