/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.client.MekanismClient;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.render.HUDRenderer;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeCustomSelectionBox;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderTickHandler {
    public final Minecraft minecraft = Minecraft.func_71410_x();
    private static final ResourceLocation POWER_BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "horizontal_power_long.png");
    private static final Map<BlockState, List<Vertex[]>> cachedWireFrames = new HashMap<BlockState, List<Vertex[]>>();
    private static final Map<Direction, Map<TransmissionType, MekanismRenderer.Model3D>> cachedOverlays = new EnumMap<Direction, Map<TransmissionType, MekanismRenderer.Model3D>>(Direction.class);
    private static final EquipmentSlotType[] EQUIPMENT_ORDER = new EquipmentSlotType[]{EquipmentSlotType.OFFHAND, EquipmentSlotType.MAINHAND, EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    private static final float HUD_SCALE = 0.6f;
    private static final HUDRenderer hudRenderer = new HUDRenderer();
    public static int modeSwitchTimer = 0;
    public static double prevRadiation = 0.0;
    private static final BoltRenderer boltRenderer = new BoltRenderer();

    public static void resetCached() {
        cachedOverlays.clear();
        cachedWireFrames.clear();
    }

    public static void renderBolt(Object renderer, BoltEffect bolt) {
        boltRenderer.update(renderer, bolt, MekanismRenderer.getPartialTick());
    }

    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent event) {
        MatrixStack matrix = event.getMatrixStack();
        matrix.func_227860_a_();
        Vector3d camVec = this.minecraft.field_71460_t.func_215316_n().func_216785_c();
        matrix.func_227861_a_(-camVec.field_72450_a, -camVec.field_72448_b, -camVec.field_72449_c);
        IRenderTypeBuffer.Impl renderer = this.minecraft.func_228019_au_().func_228487_b_();
        boltRenderer.render(this.minecraft.func_184121_ak(), matrix, (IRenderTypeBuffer)renderer);
        renderer.func_228462_a_(MekanismRenderType.MEK_LIGHTNING);
        matrix.func_227865_b_();
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
            FloatingLong capacity = FloatingLong.ZERO;
            FloatingLong stored = FloatingLong.ZERO;
            for (ItemStack stack : this.minecraft.field_71439_g.field_71071_by.field_70460_b) {
                IEnergyContainer container = StorageUtils.getEnergyContainer(stack, 0);
                if (!(stack.func_77973_b() instanceof ItemMekaSuitArmor) || container == null) continue;
                capacity = capacity.plusEqual(container.getMaxEnergy());
                stored = stored.plusEqual(container.getEnergy());
            }
            if (!capacity.isZero()) {
                int x = event.getWindow().func_198107_o() / 2 - 91;
                int y = event.getWindow().func_198087_p() - ForgeIngameGui.left_height + 2;
                int length = (int)Math.round(stored.divide(capacity).doubleValue() * 79.0);
                MatrixStack matrix = event.getMatrixStack();
                GuiUtils.renderExtendedTexture(matrix, GuiBar.BAR, 2, 2, x, y, 81, 6);
                this.minecraft.func_110434_K().func_110577_a(POWER_BAR);
                AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x + 1), (int)(y + 1), (int)length, (int)4, (float)0.0f, (float)0.0f, (int)length, (int)4, (int)79, (int)4);
                this.minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                ForgeIngameGui.left_height += 8;
            }
        }
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && !this.minecraft.field_71439_g.func_175149_v() && MekanismConfig.client.enableHUD.get() && MekanismClient.renderHUD) {
            int count = 0;
            LinkedHashMap<EquipmentSlotType, ArrayList<ITextComponent>> renderStrings = new LinkedHashMap<EquipmentSlotType, ArrayList<ITextComponent>>();
            for (EquipmentSlotType slotType : EQUIPMENT_ORDER) {
                ItemStack stack = this.minecraft.field_71439_g.func_184582_a(slotType);
                if (!(stack.func_77973_b() instanceof IItemHUDProvider)) continue;
                ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
                ((IItemHUDProvider)stack.func_77973_b()).addHUDStrings(list, stack, slotType);
                int size = list.size();
                if (size <= 0) continue;
                renderStrings.put(slotType, list);
                count += size;
            }
            int start = renderStrings.size() * 2 + count * 9;
            boolean alignLeft = MekanismConfig.client.alignHUDLeft.get();
            MainWindow window = event.getWindow();
            int y = window.func_198087_p();
            MatrixStack matrix = event.getMatrixStack();
            matrix.func_227860_a_();
            matrix.func_227862_a_(0.6f, 0.6f, 0.6f);
            for (Map.Entry entry : renderStrings.entrySet()) {
                for (ITextComponent text : (List)entry.getValue()) {
                    this.drawString(window, matrix, text, alignLeft, (int)((float)y * 1.6666666f) - start, 0xC8C8C8);
                    start -= 9;
                }
                start -= 2;
            }
            matrix.func_227865_b_();
            if (this.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemMekaSuitArmor) {
                hudRenderer.renderHUD(matrix, event.getPartialTicks());
            }
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.minecraft.field_71439_g != null && this.minecraft.field_71439_g.field_70170_p != null && !this.minecraft.func_147113_T()) {
            PlayerEntity p;
            ClientPlayerEntity player = this.minecraft.field_71439_g;
            World world = this.minecraft.field_71439_g.field_70170_p;
            MatrixStack matrix = new MatrixStack();
            this.renderStatusBar(matrix, (PlayerEntity)player);
            for (UUID uuid : Mekanism.playerState.getActiveJetpacks()) {
                p = world.func_217371_b(uuid);
                if (p == null) continue;
                Pos3D playerPos = new Pos3D((Entity)p).translate(0.0, p.func_70047_e(), 0.0);
                Vector3d playerMotion = p.func_213322_ci();
                float random = (world.field_73012_v.nextFloat() - 0.5f) * 0.1f;
                Pos3D vLeft = new Pos3D(-0.43, -0.55, -0.54).rotatePitch(p.func_213453_ef() ? 20.0f : 0.0f).rotateYaw(p.field_70761_aq);
                this.renderJetpackSmoke(world, playerPos.translate(vLeft, playerMotion), vLeft.scale(0.2).translate(playerMotion, vLeft.scale(random)));
                Pos3D vRight = new Pos3D(0.43, -0.55, -0.54).rotatePitch(p.func_213453_ef() ? 20.0f : 0.0f).rotateYaw(p.field_70761_aq);
                this.renderJetpackSmoke(world, playerPos.translate(vRight, playerMotion), vRight.scale(0.2).translate(playerMotion, vRight.scale(random)));
                Pos3D vCenter = new Pos3D(((double)world.field_73012_v.nextFloat() - 0.5) * 0.4, -0.86, -0.3).rotatePitch(p.func_213453_ef() ? 25.0f : 0.0f).rotateYaw(p.field_70761_aq);
                this.renderJetpackSmoke(world, playerPos.translate(vCenter, playerMotion), vCenter.scale(0.2).translate(playerMotion));
            }
            if (world.func_82737_E() % 4L == 0L) {
                Pos3D motion;
                for (UUID uuid : Mekanism.playerState.getActiveScubaMasks()) {
                    p = world.func_217371_b(uuid);
                    if (p == null || !p.func_70090_H()) continue;
                    Pos3D vec = new Pos3D(0.4, 0.4, 0.4).multiply(p.func_70676_i(1.0f)).translate(0.0, -0.2, 0.0);
                    motion = vec.scale(0.2).translate(p.func_213322_ci());
                    Pos3D v = new Pos3D((Entity)p).translate(0.0, p.func_70047_e(), 0.0).translate((Vector3d)vec);
                    world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.SCUBA_BUBBLE.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.2, motion.field_72449_c);
                }
                for (PlayerEntity p2 : world.func_217369_A()) {
                    Pos3D flameVec;
                    ItemStack currentItem;
                    if (p2.field_82175_bq || Mekanism.playerState.isFlamethrowerOn(p2) || (currentItem = p2.func_184614_ca()).func_190926_b() || !(currentItem.func_77973_b() instanceof ItemFlamethrower) || !ChemicalUtil.hasGas(currentItem)) continue;
                    if (player == p2 && this.minecraft.field_71474_y.func_243230_g().func_243192_a()) {
                        flameVec = new Pos3D(1.0, 1.0, 1.0).multiply(p2.func_70676_i(1.0f)).rotateYaw(5.0f).translate(0.0, (double)p2.func_70047_e() - 0.1, 0.0);
                    } else {
                        double flameXCoord = -0.2;
                        double flameYCoord = 1.0;
                        double flameZCoord = 1.2;
                        if (p2.func_213453_ef()) {
                            flameYCoord -= 0.65;
                            flameZCoord -= 0.15;
                        }
                        flameVec = new Pos3D(flameXCoord, flameYCoord, flameZCoord).rotateYaw(p2.field_70761_aq);
                    }
                    motion = p2.func_213322_ci();
                    Pos3D flameMotion = new Pos3D(motion.func_82615_a(), p2.func_233570_aj_() ? 0.0 : motion.func_82617_b(), motion.func_82616_c());
                    Pos3D playerPos = new Pos3D((Entity)p2);
                    Pos3D mergedVec = playerPos.translate((Vector3d)flameVec);
                    world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_FLAME.getParticleType()), mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c, flameMotion.field_72450_a, flameMotion.field_72448_b, flameMotion.field_72449_c);
                }
            }
            if (MekanismUtils.isPlayingMode((PlayerEntity)player)) {
                player.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> {
                    double radiation = c.getRadiation();
                    double severity = RadiationManager.RadiationScale.getScaledDoseSeverity(radiation) * 0.8;
                    if (prevRadiation < severity) {
                        prevRadiation = Math.min(severity, prevRadiation + 0.01);
                    }
                    if (prevRadiation > severity) {
                        prevRadiation = Math.max(severity, prevRadiation - 0.01);
                    }
                    if (severity > 1.0E-7) {
                        int effect = (int)(prevRadiation * 255.0);
                        int color = 1881021952 + effect;
                        MekanismRenderer.renderColorOverlay(matrix, 0, 0, this.minecraft.func_228018_at_().func_198107_o(), this.minecraft.func_228018_at_().func_198087_p(), color);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void onBlockHover(DrawHighlightEvent.HighlightBlock event) {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        BlockRayTraceResult rayTraceResult = event.getTarget();
        if (!rayTraceResult.func_216346_c().equals((Object)RayTraceResult.Type.MISS)) {
            TileEntity tile;
            World world = player.func_130014_f_();
            BlockPos pos = rayTraceResult.func_216350_a();
            IRenderTypeBuffer renderer = event.getBuffers();
            ActiveRenderInfo info = event.getInfo();
            MatrixStack matrix = event.getMatrix();
            IProfiler profiler = world.func_217381_Z();
            BlockState blockState = world.func_180495_p(pos);
            boolean shouldCancel = false;
            profiler.func_76320_a("mekOutline");
            if (!blockState.isAir((IBlockReader)world, pos) && world.func_175723_af().func_177746_a(pos)) {
                TileEntityBoundingBlock tile2;
                BlockPos actualPos = pos;
                BlockState actualState = blockState;
                if (blockState.func_177230_c() instanceof BlockBounding && (tile2 = WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)world, pos)) != null) {
                    actualPos = tile2.getMainPos();
                    actualState = world.func_180495_p(actualPos);
                }
                if (Attribute.has(actualState.func_177230_c(), AttributeCustomSelectionBox.class)) {
                    WireFrameRenderer renderWireFrame = null;
                    if (Attribute.get(actualState.func_177230_c(), AttributeCustomSelectionBox.class).isJavaModel()) {
                        TileEntityRenderer tileRenderer;
                        tile = WorldUtils.getTileEntity((IBlockReader)world, actualPos);
                        if (tile != null && (tileRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile)) instanceof IWireFrameRenderer) {
                            renderWireFrame = (buffer, matrixStack, red, green, blue, alpha) -> ((IWireFrameRenderer)tileRenderer).renderWireFrame(tile, event.getPartialTicks(), matrixStack, buffer, red, green, blue, alpha);
                        }
                    } else {
                        BlockState finalActualState = actualState;
                        renderWireFrame = (buffer, matrixStack, red, green, blue, alpha) -> this.renderQuadsWireFrame(finalActualState, buffer, matrixStack.func_227866_c_().func_227870_a_(), world.field_73012_v, red, green, blue, alpha);
                    }
                    if (renderWireFrame != null) {
                        matrix.func_227860_a_();
                        Vector3d viewPosition = info.func_216785_c();
                        matrix.func_227861_a_((double)actualPos.func_177958_n() - viewPosition.field_72450_a, (double)actualPos.func_177956_o() - viewPosition.field_72448_b, (double)actualPos.func_177952_p() - viewPosition.field_72449_c);
                        renderWireFrame.render(renderer.getBuffer(RenderType.func_228659_m_()), matrix, 0.0f, 0.0f, 0.0f, 0.4f);
                        matrix.func_227865_b_();
                        shouldCancel = true;
                    }
                }
            }
            profiler.func_76319_b();
            ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
            if (!(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator || !(stack = player.func_184586_b(Hand.OFF_HAND)).func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator)) {
                if (shouldCancel) {
                    event.setCanceled(true);
                }
                return;
            }
            profiler.func_76320_a("configurableMachine");
            ItemConfigurator.ConfiguratorMode state = ((ItemConfigurator)stack.func_77973_b()).getMode(stack);
            if (state.isConfigurating()) {
                ISideConfiguration configurable;
                TileComponentConfig config;
                TransmissionType type = Objects.requireNonNull(state.getTransmission(), "Configurating state requires transmission type");
                tile = WorldUtils.getTileEntity((IBlockReader)world, pos);
                if (tile instanceof ISideConfiguration && (config = (configurable = (ISideConfiguration)tile).getConfig()).supports(type)) {
                    Direction face = rayTraceResult.func_216354_b();
                    DataType dataType = config.getDataType(type, RelativeSide.fromDirections(configurable.getOrientation(), face));
                    if (dataType != null) {
                        Vector3d viewPosition = info.func_216785_c();
                        matrix.func_227860_a_();
                        matrix.func_227861_a_((double)pos.func_177958_n() - viewPosition.field_72450_a, (double)pos.func_177956_o() - viewPosition.field_72448_b, (double)pos.func_177952_p() - viewPosition.field_72449_c);
                        MekanismRenderer.renderObject(this.getOverlayModel(face, type), matrix, renderer.getBuffer(Atlases.func_228785_j_()), MekanismRenderer.getColorARGB(dataType.getColor(), 0.6f), 0xF000F0, OverlayTexture.field_229196_a_);
                        matrix.func_227865_b_();
                    }
                }
            }
            profiler.func_76319_b();
            if (shouldCancel) {
                event.setCanceled(true);
            }
        }
    }

    private void renderQuadsWireFrame(BlockState state, IVertexBuilder buffer, Matrix4f matrix, Random rand, float red, float green, float blue, float alpha) {
        List allVertices = cachedWireFrames.computeIfAbsent(state, s -> {
            IBakedModel bakedModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(s);
            EmptyModelData modelData = EmptyModelData.INSTANCE;
            ArrayList vertices = new ArrayList();
            for (Direction direction : EnumUtils.DIRECTIONS) {
                QuadUtils.unpack(bakedModel.getQuads(s, direction, rand, (IModelData)modelData)).stream().map(Quad::getVertices).forEach(vertices::add);
            }
            QuadUtils.unpack(bakedModel.getQuads(s, null, rand, (IModelData)modelData)).stream().map(Quad::getVertices).forEach(vertices::add);
            return vertices;
        });
        for (Vertex[] vertices : allVertices) {
            Vector4f vertex = RenderTickHandler.getVertex(matrix, vertices[0]);
            Vector3d normal = vertices[0].getNormal();
            Vector4f vertex2 = RenderTickHandler.getVertex(matrix, vertices[1]);
            Vector3d normal2 = vertices[1].getNormal();
            Vector4f vertex3 = RenderTickHandler.getVertex(matrix, vertices[2]);
            Vector3d normal3 = vertices[2].getNormal();
            Vector4f vertex4 = RenderTickHandler.getVertex(matrix, vertices[3]);
            Vector3d normal4 = vertices[3].getNormal();
            buffer.func_225582_a_((double)vertex.func_195910_a(), (double)vertex.func_195913_b(), (double)vertex.func_195914_c()).func_225584_a_((float)normal.func_82615_a(), (float)normal.func_82617_b(), (float)normal.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)vertex2.func_195910_a(), (double)vertex2.func_195913_b(), (double)vertex2.func_195914_c()).func_225584_a_((float)normal2.func_82615_a(), (float)normal2.func_82617_b(), (float)normal2.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)vertex3.func_195910_a(), (double)vertex3.func_195913_b(), (double)vertex3.func_195914_c()).func_225584_a_((float)normal3.func_82615_a(), (float)normal3.func_82617_b(), (float)normal3.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)vertex4.func_195910_a(), (double)vertex4.func_195913_b(), (double)vertex4.func_195914_c()).func_225584_a_((float)normal4.func_82615_a(), (float)normal4.func_82617_b(), (float)normal4.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)vertex2.func_195910_a(), (double)vertex2.func_195913_b(), (double)vertex2.func_195914_c()).func_225584_a_((float)normal2.func_82615_a(), (float)normal2.func_82617_b(), (float)normal2.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)vertex3.func_195910_a(), (double)vertex3.func_195913_b(), (double)vertex3.func_195914_c()).func_225584_a_((float)normal3.func_82615_a(), (float)normal3.func_82617_b(), (float)normal3.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)vertex.func_195910_a(), (double)vertex.func_195913_b(), (double)vertex.func_195914_c()).func_225584_a_((float)normal.func_82615_a(), (float)normal.func_82617_b(), (float)normal.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)vertex4.func_195910_a(), (double)vertex4.func_195913_b(), (double)vertex4.func_195914_c()).func_225584_a_((float)normal4.func_82615_a(), (float)normal4.func_82617_b(), (float)normal4.func_82616_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
    }

    private static Vector4f getVertex(Matrix4f matrix4f, Vertex vertex) {
        Vector4f vector4f = new Vector4f((float)vertex.getPos().func_82615_a(), (float)vertex.getPos().func_82617_b(), (float)vertex.getPos().func_82616_c(), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        return vector4f;
    }

    private void renderStatusBar(MatrixStack matrix, @Nonnull PlayerEntity player) {
        if (modeSwitchTimer > 1) {
            ITextComponent scrollTextComponent;
            ItemStack stack;
            if (this.minecraft.field_71462_r == null && this.minecraft.field_71466_p != null && IModeItem.isModeItem(stack = player.func_184614_ca(), EquipmentSlotType.MAINHAND) && (scrollTextComponent = ((IModeItem)stack.func_77973_b()).getScrollTextComponent(stack)) != null) {
                int x = this.minecraft.func_228018_at_().func_198107_o();
                int y = this.minecraft.func_228018_at_().func_198087_p();
                int color = Color.rgbad(1.0, 1.0, 1.0, (float)modeSwitchTimer / 100.0f).argb();
                this.minecraft.field_71466_p.func_243248_b(matrix, scrollTextComponent, (float)(x / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)scrollTextComponent) / 2), (float)(y - 60), color);
            }
            --modeSwitchTimer;
        }
    }

    private void renderJetpackSmoke(World world, Pos3D pos, Pos3D motion) {
        world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_FLAME.getParticleType()), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_SMOKE.getParticleType()), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
    }

    private void drawString(MainWindow window, MatrixStack matrix, ITextComponent text, boolean leftSide, int y, int color) {
        FontRenderer font = this.minecraft.field_71466_p;
        if (leftSide) {
            font.func_243246_a(matrix, text, 2.0f, (float)y, color);
        } else {
            int width = font.func_238414_a_((ITextProperties)text) + 2;
            font.func_243246_a(matrix, text, (float)(window.func_198107_o() - width), (float)y, color);
        }
    }

    private MekanismRenderer.Model3D getOverlayModel(Direction side, TransmissionType type) {
        if (cachedOverlays.containsKey(side) && cachedOverlays.get(side).containsKey(type)) {
            return cachedOverlays.get(side).get(type);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.setTexture(MekanismRenderer.overlays.get(type));
        cachedOverlays.computeIfAbsent(side, s -> new EnumMap(TransmissionType.class)).putIfAbsent(type, toReturn);
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = -0.001;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.001;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = -0.001;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.001;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = -0.001;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.001;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
            }
        }
        return toReturn;
    }

    @FunctionalInterface
    private static interface WireFrameRenderer {
        public void render(IVertexBuilder var1, MatrixStack var2, float var3, float var4, float var5, float var6);
    }
}

