/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.Vertex;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class QuadUtils {
    private static final float eps = 0.00390625f;

    private QuadUtils() {
    }

    public static List<Quad> unpack(List<BakedQuad> quads) {
        return quads.stream().map(Quad::new).collect(Collectors.toList());
    }

    public static List<BakedQuad> bake(List<Quad> quads) {
        return quads.stream().map(Quad::bake).collect(Collectors.toList());
    }

    public static List<Quad> flip(List<Quad> quads) {
        return quads.stream().map(Quad::flip).collect(Collectors.toList());
    }

    public static List<Quad> transformQuads(List<Quad> orig, QuadTransformation transformation) {
        ArrayList<Quad> list = new ArrayList<Quad>();
        for (Quad quad : orig) {
            transformation.transform(quad);
            list.add(quad);
        }
        return list;
    }

    public static List<BakedQuad> transformBakedQuads(List<BakedQuad> orig, QuadTransformation transformation) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (BakedQuad bakedQuad : orig) {
            Quad quad = new Quad(bakedQuad);
            transformation.transform(quad);
            list.add(quad.bake());
        }
        return list;
    }

    public static List<BakedQuad> transformAndBake(List<Quad> orig, QuadTransformation transformation) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (Quad quad : orig) {
            transformation.transform(quad);
            list.add(quad.bake());
        }
        return list;
    }

    public static void remapUVs(Quad quad, TextureAtlasSprite newTexture) {
        float uMin = quad.getTexture().func_94209_e();
        float uMax = quad.getTexture().func_94212_f();
        float vMin = quad.getTexture().func_94206_g();
        float vMax = quad.getTexture().func_94210_h();
        for (Vertex v : quad.getVertices()) {
            float newU = (v.getTexU() - uMin) * 16.0f / (uMax - uMin);
            float newV = (v.getTexV() - vMin) * 16.0f / (vMax - vMin);
            v.texRaw(newTexture.func_94214_a((double)newU), newTexture.func_94207_b((double)newV));
        }
    }

    public static void contractUVs(Quad quad) {
        TextureAtlasSprite texture = quad.getTexture();
        float sizeX = (float)texture.func_94211_a() / (texture.func_94212_f() - texture.func_94209_e());
        float sizeY = (float)texture.func_94216_b() / (texture.func_94210_h() - texture.func_94206_g());
        float ep = 1.0f / (Math.max(sizeX, sizeY) * 256.0f);
        float[] newUs = QuadUtils.contract(quad, Vertex::getTexU, ep);
        float[] newVs = QuadUtils.contract(quad, Vertex::getTexV, ep);
        for (int i = 0; i < quad.getVertices().length; ++i) {
            quad.getVertices()[i].texRaw(newUs[i], newVs[i]);
        }
    }

    private static float[] contract(Quad quad, Function<Vertex, Float> uvf, float ep) {
        int v;
        float center = 0.0f;
        float[] ret = new float[4];
        for (v = 0; v < 4; ++v) {
            center += uvf.apply(quad.getVertices()[v]).floatValue();
        }
        center /= 4.0f;
        for (v = 0; v < 4; ++v) {
            float shifted;
            float orig = uvf.apply(quad.getVertices()[v]).floatValue();
            float delta = orig - (shifted = orig * 0.99609375f + center * 0.00390625f);
            if (Math.abs(delta) < ep) {
                float centerDelta = Math.abs(orig - center);
                shifted = centerDelta < 2.0f * ep ? (orig + center) / 2.0f : orig + (delta < 0.0f ? ep : -ep);
            }
            ret[v] = shifted;
        }
        return ret;
    }
}

