/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityFluidTank;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class RenderFluidTank
extends MekanismTileEntityRenderer<TileEntityFluidTank> {
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids = new FluidRenderMap();
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedValveFluids = new FluidRenderMap();
    private static final int stages = 1400;

    public RenderFluidTank(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    @Override
    protected void render(TileEntityFluidTank tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        FluidStack fluid = tile.fluidTank.getFluid();
        float fluidScale = tile.prevScale;
        IVertexBuilder buffer = null;
        if (!fluid.isEmpty() && fluidScale > 0.0f) {
            int modelNumber = fluid.getFluid().getAttributes().isGaseous(fluid) ? 1399 : Math.min(1399, (int)(fluidScale * 1399.0f));
            buffer = renderer.getBuffer(Atlases.func_228785_j_());
            MekanismRenderer.renderObject(this.getFluidModel(fluid, modelNumber), matrix, buffer, MekanismRenderer.getColorARGB(fluid, fluidScale), MekanismRenderer.calculateGlowLight(light, fluid), overlayLight);
        }
        if (!tile.valveFluid.isEmpty() && !tile.valveFluid.getFluid().getAttributes().isGaseous(tile.valveFluid)) {
            if (buffer == null) {
                buffer = renderer.getBuffer(Atlases.func_228785_j_());
            }
            MekanismRenderer.renderObject(this.getValveModel(tile.valveFluid, Math.min(1399, (int)(fluidScale * 1399.0f))), matrix, buffer, MekanismRenderer.getColorARGB(tile.valveFluid), MekanismRenderer.calculateGlowLight(light, tile.valveFluid), overlayLight);
        }
    }

    @Override
    protected String getProfilerSection() {
        return "fluidTank";
    }

    private MekanismRenderer.Model3D getValveModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedValveFluids.containsKey(fluid) && ((Int2ObjectMap)cachedValveFluids.get(fluid)).containsKey(stage)) {
            return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedValveFluids.get(fluid)).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        MekanismRenderer.prepFlowing(model, fluid);
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            model.minX = 0.3225;
            model.minY = 0.0625 + (double)((float)stage / 1400.0f) * 0.875;
            model.minZ = 0.3225;
            model.maxX = 0.6775;
            model.maxY = 0.9275;
            model.maxZ = 0.6775;
        }
        ((Int2ObjectMap)cachedValveFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).put(stage, (Object)model);
        return model;
    }

    private MekanismRenderer.Model3D getFluidModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedCenterFluids.containsKey(fluid) && ((Int2ObjectMap)cachedCenterFluids.get(fluid)).containsKey(stage)) {
            return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedCenterFluids.get(fluid)).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            model.minX = 0.135;
            model.minY = 0.0725;
            model.minZ = 0.135;
            model.maxX = 0.865;
            model.maxY = 0.0625 + (double)((float)stage / 1400.0f) * 0.875 - 0.01;
            model.maxZ = 0.865;
        }
        ((Int2ObjectMap)cachedCenterFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).put(stage, (Object)model);
        return model;
    }
}

