/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class RenderThermalEvaporationPlant
extends MekanismTileEntityRenderer<TileEntityThermalEvaporationBlock> {
    public RenderThermalEvaporationPlant(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityThermalEvaporationBlock tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        EvaporationMultiblockData multiblock;
        if (tile.isMaster && (multiblock = (EvaporationMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && !multiblock.inputTank.isEmpty()) {
            FluidRenderData data = new FluidRenderData(multiblock.inputTank.getFluid());
            data.location = multiblock.renderLocation.func_177982_a(1, 0, 1);
            data.height = multiblock.height() - 2;
            data.length = 2;
            data.width = 2;
            matrix.func_227860_a_();
            BlockPos pos = tile.func_174877_v();
            int glow = data.calculateGlowLight(LightTexture.func_228451_a_((int)0, (int)15));
            matrix.func_227861_a_((double)(data.location.func_177958_n() - pos.func_177958_n()), (double)(data.location.func_177956_o() - pos.func_177956_o()), (double)(data.location.func_177952_p() - pos.func_177952_p()));
            IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228785_j_());
            MekanismRenderer.renderObject(ModelRenderer.getModel(data, Math.min(1.0f, multiblock.prevScale)), matrix, buffer, data.getColorARGB(multiblock.prevScale), glow, overlayLight);
            matrix.func_227865_b_();
            MekanismRenderer.renderValves(matrix, buffer, multiblock.valves, data, pos, glow, overlayLight);
        }
    }

    @Override
    protected String getProfilerSection() {
        return "thermalEvaporationController";
    }

    public boolean isGlobalRenderer(TileEntityThermalEvaporationBlock tile) {
        if (tile.isMaster) {
            EvaporationMultiblockData multiblock = (EvaporationMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && !multiblock.inputTank.isEmpty() && multiblock.renderLocation != null;
        }
        return false;
    }
}

