/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.client.render.obj.ContentsModelConfiguration;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@ParametersAreNonnullByDefault
public abstract class RenderTransmitterBase<TRANSMITTER extends TileEntityTransmitter>
extends MekanismTileEntityRenderer<TRANSMITTER> {
    public static final ResourceLocation MODEL_LOCATION = MekanismUtils.getResource(MekanismUtils.ResourceType.MODEL, "transmitter_contents.obj");
    private static final IModelConfiguration contentsConfiguration = new ContentsModelConfiguration();
    private static final Map<ContentsModelData, List<BakedQuad>> contentModelCache = new Object2ObjectOpenHashMap();

    public static void onStitch() {
        contentModelCache.clear();
    }

    private static List<BakedQuad> getBakedQuads(List<String> visible, TextureAtlasSprite icon, World world) {
        return contentModelCache.computeIfAbsent(new ContentsModelData(visible, icon), modelData -> {
            List bakedQuads = MekanismRenderer.contentsModel.bake((IModelConfiguration)new VisibleModelConfiguration(contentsConfiguration, ((ContentsModelData)modelData).visible), (ModelBakery)ModelLoader.instance(), material -> ((ContentsModelData)modelData).icon, (IModelTransform)ModelRotation.X0_Y0, ItemOverrideList.field_188022_a, MODEL_LOCATION).getQuads(null, null, world.func_201674_k(), (IModelData)EmptyModelData.INSTANCE);
            List<Quad> unpackedQuads = QuadUtils.unpack(bakedQuads);
            for (Quad unpackedQuad : unpackedQuads) {
                for (Vertex vertex : unpackedQuad.getVertices()) {
                    vertex.normal(vertex.getNormal().func_72441_c(2.5, 2.5, 2.5).func_72432_b());
                }
            }
            return QuadUtils.bake(unpackedQuads);
        });
    }

    protected RenderTransmitterBase(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void renderModel(TRANSMITTER transmitter, MatrixStack matrix, IVertexBuilder builder, int rgb, float alpha, int light, int overlayLight, TextureAtlasSprite icon) {
        this.renderModel(transmitter, matrix, builder, MekanismRenderer.getRed(rgb), MekanismRenderer.getGreen(rgb), MekanismRenderer.getBlue(rgb), alpha, light, overlayLight, icon, Arrays.stream(EnumUtils.DIRECTIONS).map(side -> side.func_176610_l() + transmitter.getTransmitter().getConnectionType((Direction)side).func_176610_l().toUpperCase(Locale.ROOT)).collect(Collectors.toList()));
    }

    protected void renderModel(TRANSMITTER transmitter, MatrixStack matrix, IVertexBuilder builder, float red, float green, float blue, float alpha, int light, int overlayLight, TextureAtlasSprite icon, List<String> visible) {
        if (!visible.isEmpty()) {
            MatrixStack.Entry entry = matrix.func_227866_c_();
            for (BakedQuad quad : RenderTransmitterBase.getBakedQuads(visible, icon, transmitter.func_145831_w())) {
                builder.addVertexData(entry, quad, red, green, blue, alpha, light, overlayLight);
            }
        }
    }

    public void render(TRANSMITTER transmitter, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight) {
        if (!MekanismConfig.client.opaqueTransmitters.get()) {
            super.func_225616_a_(transmitter, partialTick, matrix, renderer, light, overlayLight);
        }
    }

    private static class ContentsModelData {
        private final List<String> visible;
        private final TextureAtlasSprite icon;

        private ContentsModelData(List<String> visible, TextureAtlasSprite icon) {
            this.visible = visible;
            this.icon = icon;
        }

        public int hashCode() {
            return Objects.hash(this.visible, this.icon);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ContentsModelData) {
                ContentsModelData other = (ContentsModelData)o;
                return this.visible.equals(other.visible) && this.icon.equals(other.icon);
            }
            return false;
        }
    }
}

