/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import mekanism.api.Upgrade;
import mekanism.client.sound.FlamethrowerSound;
import mekanism.client.sound.GeigerSound;
import mekanism.client.sound.GravitationalModulationSound;
import mekanism.client.sound.JetpackSound;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.ScubaMaskSound;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.tile.interfaces.ITileSound;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundHandler {
    private static final Set<UUID> jetpackSounds = new ObjectOpenHashSet();
    private static final Set<UUID> scubaMaskSounds = new ObjectOpenHashSet();
    private static final Set<UUID> flamethrowerSounds = new ObjectOpenHashSet();
    private static final Set<UUID> gravitationalModulationSounds = new ObjectOpenHashSet();
    public static final Map<RadiationManager.RadiationScale, GeigerSound> radiationSoundMap = new EnumMap<RadiationManager.RadiationScale, GeigerSound>(RadiationManager.RadiationScale.class);
    private static final Long2ObjectMap<ISound> soundMap = new Long2ObjectOpenHashMap();
    private static boolean IN_MUFFLED_CHECK = false;
    private static SoundEngine soundEngine;

    private SoundHandler() {
    }

    public static void clearPlayerSounds() {
        jetpackSounds.clear();
        scubaMaskSounds.clear();
        flamethrowerSounds.clear();
        gravitationalModulationSounds.clear();
    }

    public static void clearPlayerSounds(UUID uuid) {
        jetpackSounds.remove(uuid);
        scubaMaskSounds.remove(uuid);
        flamethrowerSounds.remove(uuid);
        gravitationalModulationSounds.remove(uuid);
    }

    public static void startSound(@Nonnull IWorld world, @Nonnull UUID uuid, @Nonnull PlayerSound.SoundType soundType) {
        switch (soundType) {
            case JETPACK: {
                PlayerEntity player;
                if (jetpackSounds.contains(uuid) || (player = world.func_217371_b(uuid)) == null) break;
                jetpackSounds.add(uuid);
                SoundHandler.playSound((ISound)new JetpackSound(player));
                break;
            }
            case SCUBA_MASK: {
                PlayerEntity player;
                if (scubaMaskSounds.contains(uuid) || (player = world.func_217371_b(uuid)) == null) break;
                scubaMaskSounds.add(uuid);
                SoundHandler.playSound((ISound)new ScubaMaskSound(player));
                break;
            }
            case FLAMETHROWER: {
                PlayerEntity player;
                if (flamethrowerSounds.contains(uuid) || (player = world.func_217371_b(uuid)) == null) break;
                flamethrowerSounds.add(uuid);
                SoundHandler.playSound((ISound)new FlamethrowerSound.Active(player));
                SoundHandler.playSound((ISound)new FlamethrowerSound.Idle(player));
                break;
            }
            case GRAVITATIONAL_MODULATOR: {
                PlayerEntity player;
                if (gravitationalModulationSounds.contains(uuid) || (player = world.func_217371_b(uuid)) == null) break;
                gravitationalModulationSounds.add(uuid);
                SoundHandler.playSound((ISound)new GravitationalModulationSound(player));
            }
        }
    }

    public static void playSound(SoundEventRegistryObject<?> soundEventRO) {
        SoundHandler.playSound((SoundEvent)soundEventRO.get());
    }

    public static void playSound(SoundEvent sound) {
        SoundHandler.playSound((ISound)SimpleSound.func_194007_a((SoundEvent)sound, (float)1.0f, (float)MekanismConfig.client.baseSoundVolume.get()));
    }

    public static void playSound(ISound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    public static ISound startTileSound(SoundEvent soundEvent, SoundCategory category, float volume, BlockPos pos) {
        Object s = (ISound)soundMap.get(pos.func_218275_a());
        if (s == null || !Minecraft.func_71410_x().func_147118_V().func_215294_c(s)) {
            s = new TileTickableSound(soundEvent, category, pos, volume);
            SoundHandler.playSound(s);
            s = (ISound)soundMap.get(pos.func_218275_a());
        }
        return s;
    }

    public static void stopTileSound(BlockPos pos) {
        long posKey = pos.func_218275_a();
        ISound s = (ISound)soundMap.get(posKey);
        if (s != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(s);
            soundMap.remove(posKey);
        }
    }

    @SubscribeEvent
    public static void onSoundEngineSetup(SoundSetupEvent event) {
        if (soundEngine == null) {
            soundEngine = event.getManager();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTilePlaySound(PlaySoundEvent event) {
        ISound resultSound = event.getResultSound();
        if (resultSound == null || IN_MUFFLED_CHECK) {
            return;
        }
        ResourceLocation soundLoc = event.getSound().func_147650_b();
        if (!soundLoc.func_110624_b().startsWith("mekanism")) {
            return;
        }
        if (event.getSound() instanceof PlayerSound) {
            event.setResultSound(event.getSound());
            return;
        }
        if (event.getName().startsWith("tile.")) {
            BlockPos pos = new BlockPos(resultSound.func_147649_g() - 0.5, resultSound.func_147654_h() - 0.5, resultSound.func_147651_i() - 0.5);
            soundMap.put(pos.func_218275_a(), (Object)resultSound);
        }
    }

    private static class TileTickableSound
    extends TickableSound {
        private final float originalVolume;
        private final int checkInterval = 20 + ThreadLocalRandom.current().nextInt(20);

        TileTickableSound(SoundEvent soundEvent, SoundCategory category, BlockPos pos, float volume) {
            super(soundEvent, category);
            this.originalVolume = volume * MekanismConfig.client.baseSoundVolume.get();
            this.field_147660_d = (float)pos.func_177958_n() + 0.5f;
            this.field_147661_e = (float)pos.func_177956_o() + 0.5f;
            this.field_147658_f = (float)pos.func_177952_p() + 0.5f;
            this.field_147662_b = this.originalVolume * this.getTileVolumeFactor();
            this.field_147659_g = true;
            this.field_147665_h = 0;
        }

        public void func_73660_a() {
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() % (long)this.checkInterval == 0L) {
                IN_MUFFLED_CHECK = true;
                this.field_147662_b = this.originalVolume;
                ISound s = ForgeHooksClient.playSound((SoundEngine)soundEngine, (ISound)this);
                IN_MUFFLED_CHECK = false;
                if (s == this) {
                    this.field_147662_b = this.originalVolume * this.getTileVolumeFactor();
                } else if (s == null) {
                    this.func_239509_o_();
                } else {
                    this.field_147662_b = s.func_147653_e() * this.getTileVolumeFactor();
                }
            }
        }

        private float getTileVolumeFactor() {
            IUpgradeTile upgradeTile;
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)Minecraft.func_71410_x().field_71441_e, new BlockPos(this.func_147649_g(), this.func_147654_h(), this.func_147651_i()));
            float retVolume = 1.0f;
            if (tile instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)tile).supportsUpgrades() && upgradeTile.getComponent().supports(Upgrade.MUFFLING)) {
                int mufflerCount = upgradeTile.getComponent().getUpgrades(Upgrade.MUFFLING);
                retVolume = 1.0f - (float)mufflerCount / (float)Upgrade.MUFFLING.getMax();
            }
            if (tile instanceof ITileSound) {
                retVolume *= ((ITileSound)tile).getVolume();
            }
            return retVolume;
        }

        public float func_147653_e() {
            if (this.field_184367_a == null) {
                this.func_184366_a(Minecraft.func_71410_x().func_147118_V());
            }
            return super.func_147653_e();
        }

        public boolean func_211503_n() {
            return true;
        }
    }
}

