/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.chunkloading.ChunkManager;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.world.GenHandler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonWorldTickHandler {
    private static final long maximumDeltaTimeNanoSecs = 16000000L;
    private Map<ResourceLocation, Queue<ChunkPos>> chunkRegenMap;
    public static boolean flushTagAndRecipeCaches;

    public void addRegenChunk(RegistryKey<World> dimension, ChunkPos chunkCoord) {
        ResourceLocation dimensionName;
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new Object2ObjectArrayMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionName = dimension.func_240901_a_())) {
            LinkedList<ChunkPos> list = new LinkedList<ChunkPos>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionName, list);
        } else {
            Queue<ChunkPos> regenPositions = this.chunkRegenMap.get(dimensionName);
            if (!regenPositions.contains(chunkCoord)) {
                regenPositions.add(chunkCoord);
            }
        }
    }

    public void resetRegenChunks() {
        if (this.chunkRegenMap != null) {
            this.chunkRegenMap.clear();
        }
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            FrequencyManager.load();
            Mekanism.radiationManager.createOrLoad();
            if (event.getWorld() instanceof ServerWorld) {
                ChunkManager.worldLoad((ServerWorld)event.getWorld());
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.serverTick();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.tickEnd((ServerWorld)event.world);
        }
    }

    private void serverTick() {
        FrequencyManager.tick();
        Mekanism.radiationManager.tickServer();
    }

    private void tickEnd(ServerWorld world) {
        if (!world.field_72995_K) {
            Mekanism.radiationManager.tickServerWorld((World)world);
            ChunkManager.tick(world);
            flushTagAndRecipeCaches = false;
            if (this.chunkRegenMap == null || !MekanismConfig.world.enableRegeneration.get()) {
                return;
            }
            ResourceLocation dimensionName = world.func_234923_W_().func_240901_a_();
            if (this.chunkRegenMap.containsKey(dimensionName)) {
                ChunkPos nextChunk;
                Queue<ChunkPos> chunksToGen = this.chunkRegenMap.get(dimensionName);
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                    Random fmlRandom = new Random(world.func_72905_C());
                    long xSeed = fmlRandom.nextLong() >> 3;
                    long zSeed = fmlRandom.nextLong() >> 3;
                    fmlRandom.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ world.func_72905_C());
                    if (!GenHandler.generate(world, fmlRandom, nextChunk.field_77276_a, nextChunk.field_77275_b)) continue;
                    Mekanism.logger.info("Regenerating ores at chunk {}", (Object)nextChunk);
                }
                if (chunksToGen.isEmpty()) {
                    this.chunkRegenMap.remove(dimensionName);
                }
            }
        }
    }
}

