/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.math.FloatingLong;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.Modules;
import mekanism.common.content.gear.mekasuit.ModuleMekaSuit;
import mekanism.common.network.PacketFlyingSync;
import mekanism.common.network.PacketGearStateUpdate;
import mekanism.common.network.PacketStepHeightSync;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class PlayerState {
    private final Set<UUID> activeJetpacks = new ObjectOpenHashSet();
    private final Set<UUID> activeScubaMasks = new ObjectOpenHashSet();
    private final Set<UUID> activeGravitationalModulators = new ObjectOpenHashSet();
    private final Set<UUID> activeFlamethrowers = new ObjectOpenHashSet();
    private final Object2FloatMap<UUID> stepAssistedPlayers = new Object2FloatOpenHashMap();
    private final Map<UUID, FlightInfo> flightInfoMap = new Object2ObjectOpenHashMap();
    private IWorld world;

    public void clear() {
        this.activeJetpacks.clear();
        this.activeScubaMasks.clear();
        this.stepAssistedPlayers.clear();
        this.activeGravitationalModulators.clear();
        this.flightInfoMap.clear();
        this.activeFlamethrowers.clear();
        if (FMLEnvironment.dist.isClient()) {
            SoundHandler.clearPlayerSounds();
        }
    }

    public void clearPlayer(UUID uuid) {
        this.activeJetpacks.remove(uuid);
        this.activeScubaMasks.remove(uuid);
        this.stepAssistedPlayers.removeFloat((Object)uuid);
        this.activeGravitationalModulators.remove(uuid);
        this.flightInfoMap.remove(uuid);
        this.activeFlamethrowers.remove(uuid);
        if (FMLEnvironment.dist.isClient()) {
            SoundHandler.clearPlayerSounds(uuid);
            if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(uuid)) {
                SoundHandler.radiationSoundMap.clear();
            }
        }
        Mekanism.radiationManager.resetPlayer(uuid);
    }

    public void init(IWorld world) {
        this.world = world;
    }

    public void setJetpackState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeJetpacks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeJetpacks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeJetpacks.add(uuid);
        }
        if (changed && this.world.func_201670_d()) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.JETPACK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.JETPACK);
            }
        }
    }

    public boolean isJetpackOn(PlayerEntity p) {
        return this.activeJetpacks.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveJetpacks() {
        return this.activeJetpacks;
    }

    public void setScubaMaskState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeScubaMasks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeScubaMasks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeScubaMasks.add(uuid);
        }
        if (changed && this.world.func_201670_d()) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.SCUBA_MASK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.SCUBA_MASK);
            }
        }
    }

    public boolean isScubaMaskOn(PlayerEntity p) {
        return this.activeScubaMasks.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveScubaMasks() {
        return this.activeScubaMasks;
    }

    public void updateStepAssist(PlayerEntity player) {
        UUID uuid = player.func_110124_au();
        float additionalHeight = CommonPlayerTickHandler.getStepBoost(player);
        if (additionalHeight == 0.0f) {
            if (this.stepAssistedPlayers.containsKey((Object)uuid)) {
                this.stepAssistedPlayers.removeFloat((Object)uuid);
                this.updateClientServerStepHeight(player, 0.6f);
            }
        } else {
            float totalHeight = 0.6f + additionalHeight;
            if (!this.stepAssistedPlayers.containsKey((Object)uuid) || this.stepAssistedPlayers.getFloat((Object)uuid) != totalHeight) {
                this.stepAssistedPlayers.put((Object)uuid, totalHeight);
                this.updateClientServerStepHeight(player, totalHeight);
            }
        }
    }

    private void updateClientServerStepHeight(PlayerEntity player, float value) {
        player.field_70138_W = value;
        Mekanism.packetHandler.sendTo(new PacketStepHeightSync(value), (ServerPlayerEntity)player);
    }

    public void setGravitationalModulationState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeGravitationalModulators.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeGravitationalModulators.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeGravitationalModulators.add(uuid);
        }
        if (changed && this.world.func_201670_d()) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.GRAVITATIONAL_MODULATOR, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.GRAVITATIONAL_MODULATOR);
            }
        }
    }

    public boolean isGravitationalModulationOn(PlayerEntity p) {
        return this.activeGravitationalModulators.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveGravitationalModulators() {
        return this.activeGravitationalModulators;
    }

    public void updateFlightInfo(PlayerEntity player) {
        boolean isFlyingGameMode = !MekanismUtils.isPlayingMode(player);
        boolean hasGravitationalModulator = CommonPlayerTickHandler.isGravitationalModulationReady(player);
        FlightInfo flightInfo = this.flightInfoMap.computeIfAbsent(player.func_110124_au(), uuid -> new FlightInfo());
        if (isFlyingGameMode || hasGravitationalModulator) {
            if (!flightInfo.hadFlightItem) {
                if (!player.field_71075_bZ.field_75101_c) {
                    this.updateClientServerFlight(player, true);
                }
                flightInfo.hadFlightItem = true;
            } else if (flightInfo.wasFlyingGameMode && !isFlyingGameMode) {
                this.updateClientServerFlight(player, true, flightInfo.wasFlying);
            } else if (flightInfo.wasFlyingAllowed && !player.field_71075_bZ.field_75101_c) {
                this.updateClientServerFlight(player, true, flightInfo.wasFlying);
            }
            flightInfo.wasFlyingGameMode = isFlyingGameMode;
            flightInfo.wasFlying = player.field_71075_bZ.field_75100_b;
            flightInfo.wasFlyingAllowed = player.field_71075_bZ.field_75101_c;
            if (player.field_71075_bZ.field_75100_b && hasGravitationalModulator) {
                FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get();
                boolean boostKey = Mekanism.keyMap.has(player.func_110124_au(), 2);
                ModuleMekaSuit.ModuleGravitationalModulatingUnit module = Modules.load(player.func_184582_a(EquipmentSlotType.CHEST), Modules.GRAVITATIONAL_MODULATING_UNIT);
                player.func_70031_b(false);
                if (boostKey) {
                    player.func_213309_a(module.getBoost(), new Vector3d(0.0, 0.0, 1.0));
                }
                module.useEnergy((LivingEntity)player, boostKey ? usage.multiply(4L) : usage);
            }
        } else {
            if (flightInfo.hadFlightItem) {
                if (player.field_71075_bZ.field_75101_c) {
                    this.updateClientServerFlight(player, false);
                }
                flightInfo.hadFlightItem = false;
            }
            flightInfo.wasFlyingGameMode = false;
            flightInfo.wasFlying = player.field_71075_bZ.field_75100_b;
            flightInfo.wasFlyingAllowed = player.field_71075_bZ.field_75101_c;
        }
    }

    private void updateClientServerFlight(PlayerEntity player, boolean allowFlying) {
        this.updateClientServerFlight(player, allowFlying, allowFlying && player.field_71075_bZ.field_75100_b);
    }

    private void updateClientServerFlight(PlayerEntity player, boolean allowFlying, boolean isFlying) {
        Mekanism.packetHandler.sendTo(new PacketFlyingSync(allowFlying, isFlying), (ServerPlayerEntity)player);
        player.field_71075_bZ.field_75101_c = allowFlying;
        player.field_71075_bZ.field_75100_b = isFlying;
    }

    public void setFlamethrowerState(UUID uuid, boolean isActive, boolean isLocal) {
        this.setFlamethrowerState(uuid, isActive, isActive, isLocal);
    }

    public void setFlamethrowerState(UUID uuid, boolean hasFlameThrower, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeFlamethrowers.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeFlamethrowers.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeFlamethrowers.add(uuid);
        }
        if (this.world.func_201670_d()) {
            boolean startSound;
            if (changed) {
                if (isLocal) {
                    Mekanism.packetHandler.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.FLAMETHROWER, uuid, isActive));
                }
                startSound = isActive;
            } else {
                boolean bl2 = startSound = !isActive && hasFlameThrower;
            }
            if (startSound && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.FLAMETHROWER);
            }
        }
    }

    public boolean isFlamethrowerOn(PlayerEntity p) {
        return this.activeFlamethrowers.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveFlamethrowers() {
        return this.activeFlamethrowers;
    }

    private static class FlightInfo {
        public boolean hadFlightItem;
        public boolean wasFlyingGameMode;
        public boolean wasFlyingAllowed;
        public boolean wasFlying;

        private FlightInfo() {
        }
    }
}

