/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class TagCache {
    private static final Map<String, List<ItemStack>> blockTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> modIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<Material, List<ItemStack>> materialStacks = new Object2ObjectOpenHashMap();
    private static final Map<Block, List<String>> tileEntityTypeTagCache = new Object2ObjectOpenHashMap();

    private TagCache() {
    }

    public static void resetVanillaTagCaches() {
        blockTagStacks.clear();
        itemTagStacks.clear();
    }

    public static void resetCustomTagCaches() {
        tileEntityTypeTagCache.clear();
    }

    public static List<String> getItemTags(@Nonnull ItemStack check) {
        return TagCache.getTagsAsStrings(check.func_77973_b().getTags());
    }

    public static List<String> getTileEntityTypeTags(@Nonnull Block block) {
        List<String> tagsAsString;
        if (tileEntityTypeTagCache.containsKey(block)) {
            return tileEntityTypeTagCache.get(block);
        }
        if (block instanceof IHasTileEntity) {
            tagsAsString = TagCache.getTagsAsStrings(((IHasTileEntity)block).getTileType().getTags());
        } else if (block.hasTileEntity(block.func_176223_P())) {
            HashSet<ResourceLocation> tileEntityTags = new HashSet<ResourceLocation>();
            for (TileEntityType tileEntityType : ForgeRegistries.TILE_ENTITIES) {
                if (!tileEntityType.func_223045_a(block)) continue;
                tileEntityTags.addAll(tileEntityType.getTags());
            }
            tagsAsString = TagCache.getTagsAsStrings(tileEntityTags);
        } else {
            tagsAsString = Collections.emptyList();
        }
        tileEntityTypeTagCache.put(block, tagsAsString);
        return tagsAsString;
    }

    public static List<String> getTagsAsStrings(@Nonnull Set<ResourceLocation> tags) {
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder asStrings = ImmutableList.builder();
        for (ResourceLocation tag : tags) {
            asStrings.add((Object)tag.toString());
        }
        return asStrings.build();
    }

    public static List<ItemStack> getItemTagStacks(@Nonnull String oreName) {
        if (itemTagStacks.containsKey(oreName)) {
            return itemTagStacks.get(oreName);
        }
        ITagCollection tagCollection = ItemTags.func_199903_a();
        List keys = tagCollection.func_199908_a().stream().filter(rl -> WildcardMatcher.matches(oreName, rl.toString())).collect(Collectors.toList());
        HashSet items = new HashSet();
        for (ResourceLocation key : keys) {
            ITag itemTag = tagCollection.func_199910_a(key);
            if (itemTag == null) continue;
            items.addAll(itemTag.func_230236_b_());
        }
        List<ItemStack> stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        itemTagStacks.put(oreName, stacks);
        return stacks;
    }

    public static List<ItemStack> getBlockTagStacks(@Nonnull String oreName) {
        if (blockTagStacks.containsKey(oreName)) {
            return blockTagStacks.get(oreName);
        }
        ITagCollection tagCollection = BlockTags.func_199896_a();
        List keys = tagCollection.func_199908_a().stream().filter(rl -> WildcardMatcher.matches(oreName, rl.toString())).collect(Collectors.toList());
        HashSet blocks = new HashSet();
        for (ResourceLocation key : keys) {
            ITag blockTag = tagCollection.func_199910_a(key);
            if (blockTag == null) continue;
            blocks.addAll(blockTag.func_230236_b_());
        }
        List<ItemStack> stacks = blocks.stream().map(ItemStack::new).collect(Collectors.toList());
        blockTagStacks.put(oreName, stacks);
        return stacks;
    }

    public static List<ItemStack> getModIDStacks(@Nonnull String modName, boolean forceBlock) {
        if (modIDStacks.containsKey(modName)) {
            return modIDStacks.get(modName);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack stack;
            if (forceBlock && !(item instanceof BlockItem) || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof BlockBounding || !WildcardMatcher.matches(modName, MekanismUtils.getModId(stack = new ItemStack((IItemProvider)item)))) continue;
            stacks.add(stack);
        }
        modIDStacks.put(modName, stacks);
        return stacks;
    }

    public static List<ItemStack> getMaterialStacks(@Nonnull ItemStack stack) {
        return TagCache.getMaterialStacks(Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_185904_a());
    }

    public static List<ItemStack> getMaterialStacks(@Nonnull Material material) {
        if (materialStacks.containsKey(material)) {
            return materialStacks.get(material);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            Block block;
            if (!(item instanceof BlockItem) || (block = ((BlockItem)item).func_179223_d()) instanceof BlockBounding || block.func_176223_P().func_185904_a() != material) continue;
            stacks.add(new ItemStack((IItemProvider)item));
        }
        materialStacks.put(material, stacks);
        return stacks;
    }
}

