/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.text.NumberFormat;
import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tile.TileEntityRadioactiveWasteBarrel;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockRadioactiveWasteBarrel
extends BlockTile.BlockTileModel<TileEntityRadioactiveWasteBarrel, BlockTypeTile<TileEntityRadioactiveWasteBarrel>> {
    private static final NumberFormat intFormatter = NumberFormat.getIntegerInstance();

    public BlockRadioactiveWasteBarrel() {
        super(MekanismBlockTypes.RADIOACTIVE_WASTE_BARREL);
    }

    @Override
    public void func_180655_c(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random random) {
        int count;
        TileEntityRadioactiveWasteBarrel tile = WorldUtils.getTileEntity(TileEntityRadioactiveWasteBarrel.class, (IBlockReader)world, pos);
        if (tile != null && (count = (int)(10.0f * tile.getGasScale())) > 0) {
            for (int i = 0; i < random.nextInt(count); ++i) {
                double randX = (double)pos.func_177958_n() - 0.1 + random.nextDouble() * 1.2;
                double randY = (double)pos.func_177956_o() - 0.1 + random.nextDouble() * 1.2;
                double randZ = (double)pos.func_177952_p() - 0.1 + random.nextDouble() * 1.2;
                world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.RADIATION.getParticleType()), randX, randY, randZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    @Deprecated
    public float func_180647_a(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        float speed = super.func_180647_a(state, player, world, pos);
        TileEntityRadioactiveWasteBarrel tile = WorldUtils.getTileEntity(TileEntityRadioactiveWasteBarrel.class, world, pos);
        return tile != null && tile.getGasScale() > 0.0f ? speed / 5.0f : speed;
    }

    @Override
    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        if (!player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        TileEntityRadioactiveWasteBarrel tile = WorldUtils.getTileEntity(TileEntityRadioactiveWasteBarrel.class, (IBlockReader)world, pos);
        if (tile == null) {
            return ActionResultType.PASS;
        }
        if (!world.func_201670_d()) {
            IFormattableTextComponent text;
            GasStack stored = tile.getGas();
            if (stored.isEmpty()) {
                text = MekanismLang.NO_GAS.translateColored(EnumColor.GRAY, new Object[0]);
            } else {
                String scale = TextUtils.getPercent(tile.getGasScale());
                text = MekanismLang.STORED_MB_PERCENTAGE.translateColored(EnumColor.ORANGE, EnumColor.ORANGE, stored, EnumColor.GRAY, intFormatter.format(stored.getAmount()), scale);
            }
            player.func_145747_a((ITextComponent)text, Util.field_240973_b_);
        }
        return ActionResultType.SUCCESS;
    }
}

