/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.function.ToIntFunction;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.block.AbstractBlock;

public class Attributes {
    private Attributes() {
    }

    public static class AttributeLight
    implements Attribute {
        private final int light;

        public AttributeLight(int light) {
            this.light = light;
        }

        @Override
        public void adjustProperties(AbstractBlock.Properties props) {
            props.func_235838_a_(state -> this.light);
        }
    }

    public static class AttributeCustomResistance
    implements Attribute {
        private final float resistance;

        public AttributeCustomResistance(float resistance) {
            this.resistance = resistance;
        }

        public float getResistance() {
            return this.resistance;
        }
    }

    public static class AttributeRedstoneEmitter<TILE extends TileEntityMekanism>
    implements Attribute.TileAttribute<TILE> {
        private final ToIntFunction<TILE> redstoneFunction;

        public AttributeRedstoneEmitter(ToIntFunction<TILE> redstoneFunction) {
            this.redstoneFunction = redstoneFunction;
        }

        public int getRedstoneLevel(TILE tile) {
            return this.redstoneFunction.applyAsInt(tile);
        }
    }

    public static class AttributeMultiblock
    implements Attribute {
    }

    public static class AttributeNoMobSpawn
    implements Attribute {
    }

    public static class AttributeRedstone
    implements Attribute {
    }

    public static class AttributeComparator
    implements Attribute {
    }

    public static class AttributeInventory
    implements Attribute {
    }

    public static class AttributeSecurity
    implements Attribute {
    }
}

