/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IMekWrench;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockLogisticalSorter
extends BlockTile.BlockTileModel<TileEntityLogisticalSorter, Machine<TileEntityLogisticalSorter>> {
    public BlockLogisticalSorter() {
        super(MekanismBlockTypes.LOGISTICAL_SORTER);
    }

    @Override
    public void setTileData(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack, @Nonnull TileEntityMekanism tile) {
        TileEntityLogisticalSorter transporter;
        if (tile instanceof TileEntityLogisticalSorter && !(transporter = (TileEntityLogisticalSorter)tile).hasConnectedInventory()) {
            BlockPos tilePos = tile.func_174877_v();
            for (Direction dir : EnumUtils.DIRECTIONS) {
                TileEntity tileEntity = WorldUtils.getTileEntity((IBlockReader)world, tilePos.func_177972_a(dir));
                if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                transporter.setFacing(dir.func_176734_d());
                break;
            }
        }
    }

    @Override
    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        IMekWrench wrenchHandler;
        TileEntityLogisticalSorter tile = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (IBlockReader)world, pos);
        if (tile == null) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return this.genericClientActivated(player, hand, hit);
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (wrenchHandler = MekanismUtils.getWrench(stack)) != null && wrenchHandler.canUseWrench(stack, player, hit.func_216350_a())) {
            if (SecurityUtils.canAccess(player, tile)) {
                if (player.func_225608_bj_()) {
                    WorldUtils.dismantleBlock(state, world, pos);
                    return ActionResultType.SUCCESS;
                }
                Direction change = tile.getDirection().func_176746_e();
                if (!tile.hasConnectedInventory()) {
                    for (Direction dir : EnumUtils.DIRECTIONS) {
                        TileEntity tileEntity = WorldUtils.getTileEntity((IBlockReader)world, pos.func_177972_a(dir));
                        if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                        change = dir.func_176734_d();
                        break;
                    }
                }
                tile.setFacing(change);
                world.func_195593_d(pos, (Block)this);
            } else {
                SecurityUtils.displayNoAccess(player);
            }
            return ActionResultType.SUCCESS;
        }
        return tile.openGui(player);
    }

    @Override
    @Nonnull
    @Deprecated
    public BlockState func_196271_a(BlockState state, @Nonnull Direction dir, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockPos neighborPos) {
        TileEntity tileEntity;
        TileEntityLogisticalSorter sorter;
        if (!world.func_201670_d() && (sorter = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (IBlockReader)world, pos)) != null && !sorter.hasConnectedInventory() && InventoryUtils.isItemHandler(tileEntity = WorldUtils.getTileEntity((IBlockReader)world, neighborPos), dir)) {
            sorter.setFacing(dir.func_176734_d());
            state = sorter.func_195044_w();
        }
        return super.func_196271_a(state, dir, facingState, world, pos, neighborPos);
    }
}

