/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.chemical.item.ItemStackMekanismGasHandler;
import mekanism.common.capabilities.chemical.variable.RateLimitChemicalTank;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RateLimitMultiTankGasHandler
extends ItemStackMekanismGasHandler {
    private final List<IGasTank> tanks;

    public static RateLimitMultiTankGasHandler create(@NonNull Collection<GasTankSpec> gasTanks) {
        ArrayList<Function<IGasHandler.IMekanismGasHandler, IGasTank>> tankProviders = new ArrayList<Function<IGasHandler.IMekanismGasHandler, IGasTank>>();
        for (GasTankSpec spec : gasTanks) {
            tankProviders.add(handler -> new RateLimitChemicalTank.RateLimitGasTank(spec.rate, spec.capacity, spec.canExtract, spec.canInsert, spec.isValid, null, (IContentsListener)handler));
        }
        return new RateLimitMultiTankGasHandler(tankProviders);
    }

    private RateLimitMultiTankGasHandler(List<Function<IGasHandler.IMekanismGasHandler, IGasTank>> tankProviders) {
        this.tanks = new ArrayList<IGasTank>(tankProviders.size());
        for (Function<IGasHandler.IMekanismGasHandler, IGasTank> provider : tankProviders) {
            this.tanks.add(provider.apply(this));
        }
    }

    @Override
    protected List<IGasTank> getInitialTanks() {
        return this.tanks;
    }

    public static class GasTankSpec {
        final LongSupplier rate;
        final LongSupplier capacity;
        final Predicate<@NonNull Gas> isValid;
        final BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract;
        final BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert;

        public GasTankSpec(LongSupplier rate, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> isValid) {
            this.rate = rate;
            this.capacity = capacity;
            this.isValid = isValid;
            this.canExtract = canExtract;
            this.canInsert = canInsert;
        }

        public static GasTankSpec create(LongSupplier rate, LongSupplier capacity) {
            return new GasTankSpec(rate, capacity, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrue);
        }

        public static GasTankSpec createFillOnly(LongSupplier rate, LongSupplier capacity, Predicate<@NonNull Gas> isValid) {
            return new GasTankSpec(rate, capacity, (item, automationType) -> automationType != AutomationType.EXTERNAL, ChemicalTankBuilder.GAS.alwaysTrueBi, isValid);
        }

        public boolean isValid(@NonNull Gas gas) {
            return this.isValid.test(gas);
        }
    }
}

