/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BasicFluidTank
implements IExtendedFluidTank {
    public static final Predicate<@NonNull FluidStack> alwaysTrue = stack -> true;
    public static final Predicate<@NonNull FluidStack> alwaysFalse = stack -> false;
    public static final BiPredicate<@NonNull FluidStack, @NonNull AutomationType> alwaysTrueBi = (stack, automationType) -> true;
    public static final BiPredicate<@NonNull FluidStack, @NonNull AutomationType> internalOnly = (stack, automationType) -> automationType == AutomationType.INTERNAL;
    public static final BiPredicate<@NonNull FluidStack, @NonNull AutomationType> notExternal = (stack, automationType) -> automationType != AutomationType.EXTERNAL;
    protected FluidStack stored = FluidStack.EMPTY;
    private final Predicate<@NonNull FluidStack> validator;
    protected final BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canExtract;
    protected final BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canInsert;
    private final int capacity;
    @Nullable
    private final IContentsListener listener;

    public static BasicFluidTank create(int capacity, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return new BasicFluidTank(capacity, alwaysTrueBi, alwaysTrueBi, alwaysTrue, listener);
    }

    public static BasicFluidTank create(int capacity, Predicate<@NonNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, alwaysTrueBi, alwaysTrueBi, validator, listener);
    }

    public static BasicFluidTank create(int capacity, Predicate<@NonNull FluidStack> canExtract, Predicate<@NonNull FluidStack> canInsert, @Nullable IContentsListener listener) {
        return BasicFluidTank.create(capacity, canExtract, canInsert, alwaysTrue, listener);
    }

    public static BasicFluidTank input(int capacity, Predicate<@NonNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, notExternal, alwaysTrueBi, validator, listener);
    }

    public static BasicFluidTank output(int capacity, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return new BasicFluidTank(capacity, alwaysTrueBi, internalOnly, alwaysTrue, listener);
    }

    public static BasicFluidTank create(int capacity, Predicate<@NonNull FluidStack> canExtract, Predicate<@NonNull FluidStack> canInsert, Predicate<@NonNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, canExtract, canInsert, validator, listener);
    }

    public static BasicFluidTank create(int capacity, BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canInsert, Predicate<@NonNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, canExtract, canInsert, validator, listener);
    }

    protected BasicFluidTank(int capacity, Predicate<@NonNull FluidStack> canExtract, Predicate<@NonNull FluidStack> canInsert, Predicate<@NonNull FluidStack> validator, @Nullable IContentsListener listener) {
        this(capacity, (FluidStack stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test((FluidStack)stack), (FluidStack stack, AutomationType automationType) -> canInsert.test((FluidStack)stack), validator, listener);
    }

    protected BasicFluidTank(int capacity, BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull FluidStack, @NonNull AutomationType> canInsert, Predicate<@NonNull FluidStack> validator, @Nullable IContentsListener listener) {
        this.capacity = capacity;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.listener = listener;
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    public FluidStack getFluid() {
        return this.stored;
    }

    @Override
    public void setStack(FluidStack stack) {
        this.setStack(stack, true);
    }

    protected int getRate(@Nullable AutomationType automationType) {
        return Integer.MAX_VALUE;
    }

    protected void setStackUnchecked(FluidStack stack) {
        this.setStack(stack, false);
    }

    private void setStack(FluidStack stack, boolean validateStack) {
        if (stack.isEmpty()) {
            this.stored = FluidStack.EMPTY;
        } else if (!validateStack || this.isFluidValid(stack)) {
            this.stored = new FluidStack(stack, stack.getAmount());
        } else {
            throw new RuntimeException("Invalid fluid for tank: " + stack.getFluid().getRegistryName() + " " + stack.getAmount());
        }
        this.onContentsChanged();
    }

    @Override
    public FluidStack insert(@Nonnull FluidStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty() || !this.isFluidValid(stack) || !this.canInsert.test(stack, automationType)) {
            return stack;
        }
        int needed = Math.min(this.getRate(automationType), this.getNeeded());
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = this.stored.isFluidEqual(stack))) {
            int toAdd = Math.min(stack.getAmount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.stored.grow(toAdd);
                    this.onContentsChanged();
                } else {
                    this.setStackUnchecked(new FluidStack(stack, toAdd));
                }
            }
            return new FluidStack(stack, stack.getAmount() - toAdd);
        }
        return stack;
    }

    @Override
    public FluidStack extract(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1 || !this.canExtract.test(this.stored, automationType)) {
            return FluidStack.EMPTY;
        }
        int size = Math.min(Math.min(this.getRate(automationType), this.getFluidAmount()), amount);
        if (size == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack ret = new FluidStack(this.stored, size);
        if (!ret.isEmpty() && action.execute()) {
            this.stored.shrink(ret.getAmount());
            this.onContentsChanged();
        }
        return ret;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0;
        }
        int maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getFluidAmount() == amount || action.simulate()) {
            return amount;
        }
        this.stored.setAmount(amount);
        this.onContentsChanged();
        return amount;
    }

    @Override
    public int growStack(int amount, Action action) {
        int current = this.getFluidAmount();
        if (amount > 0) {
            amount = Math.min(Math.min(amount, this.getNeeded()), this.getRate(null));
        } else if (amount < 0) {
            amount = Math.max(amount, -this.getRate(null));
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    @Override
    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    @Override
    public boolean isFluidEqual(FluidStack other) {
        return this.stored.isFluidEqual(other);
    }

    public int getFluidAmount() {
        return this.stored.getAmount();
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.isEmpty()) {
            nbt.func_218657_a("stored", (INBT)this.stored.writeToNBT(new CompoundNBT()));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        NBTUtils.setFluidStackIfPresent(nbt, "stored", this::setStackUnchecked);
    }
}

