/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackMekanismFluidHandler
extends ItemCapabilityWrapper.ItemCapability
implements IMekanismFluidHandler,
IFluidHandlerItem {
    protected List<IExtendedFluidTank> tanks;

    protected abstract List<IExtendedFluidTank> getInitialTanks();

    @Override
    protected void init() {
        this.tanks = this.getInitialTanks();
    }

    @Override
    protected void load() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            DataHandlerUtils.readContainers(this.getFluidTanks(null), ItemDataUtils.getList(stack, "FluidTanks"));
        }
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.tanks;
    }

    @Override
    public void onContentsChanged() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            ItemDataUtils.setList(stack, "FluidTanks", DataHandlerUtils.writeContainers(this.getFluidTanks(null)));
        }
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.getStack();
    }

    @Override
    protected void addCapabilityResolvers(CapabilityCache capabilityCache) {
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, this));
    }
}

