/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.merged;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.fluid.FluidTankWrapper;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MergedTank
extends MergedChemicalTank {
    private final IExtendedFluidTank fluidTank;

    public static MergedTank create(IExtendedFluidTank fluidTank, IGasTank gasTank, IInfusionTank infusionTank, IPigmentTank pigmentTank, ISlurryTank slurryTank) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(infusionTank, "Infusion tank cannot be null");
        Objects.requireNonNull(pigmentTank, "Pigment tank cannot be null");
        Objects.requireNonNull(slurryTank, "Slurry tank cannot be null");
        return new MergedTank(fluidTank, gasTank, infusionTank, pigmentTank, slurryTank);
    }

    private MergedTank(IExtendedFluidTank fluidTank, IChemicalTank<?, ?> ... chemicalTanks) {
        super(fluidTank::isEmpty, chemicalTanks);
        this.fluidTank = new FluidTankWrapper(this, fluidTank, () -> Arrays.stream(chemicalTanks).allMatch(IChemicalTank::isEmpty));
    }

    public CurrentType getCurrentType() {
        if (!this.getFluidTank().isEmpty()) {
            return CurrentType.FLUID;
        }
        switch (this.getCurrent()) {
            case EMPTY: {
                return CurrentType.EMPTY;
            }
            case GAS: {
                return CurrentType.GAS;
            }
            case INFUSION: {
                return CurrentType.INFUSION;
            }
            case PIGMENT: {
                return CurrentType.PIGMENT;
            }
            case SLURRY: {
                return CurrentType.SLURRY;
            }
        }
        return CurrentType.EMPTY;
    }

    public final IExtendedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void addToUpdateTag(CompoundNBT updateTag) {
        updateTag.func_218657_a("fluid", (INBT)this.getFluidTank().getFluid().writeToNBT(new CompoundNBT()));
        updateTag.func_218657_a("gas", (INBT)((GasStack)this.getGasTank().getStack()).write(new CompoundNBT()));
        updateTag.func_218657_a("infuseTypeName", (INBT)((InfusionStack)this.getInfusionTank().getStack()).write(new CompoundNBT()));
        updateTag.func_218657_a("pigment", (INBT)((PigmentStack)this.getPigmentTank().getStack()).write(new CompoundNBT()));
        updateTag.func_218657_a("slurry", (INBT)((SlurryStack)this.getSlurryTank().getStack()).write(new CompoundNBT()));
    }

    public void readFromUpdateTag(CompoundNBT tag) {
        NBTUtils.setFluidStackIfPresent(tag, "fluid", value -> this.getFluidTank().setStack((FluidStack)value));
        NBTUtils.setGasStackIfPresent(tag, "gas", value -> this.getGasTank().setStack(value));
        NBTUtils.setInfusionStackIfPresent(tag, "infuseTypeName", value -> this.getInfusionTank().setStack(value));
        NBTUtils.setPigmentStackIfPresent(tag, "pigment", value -> this.getPigmentTank().setStack(value));
        NBTUtils.setSlurryStackIfPresent(tag, "slurry", value -> this.getSlurryTank().setStack(value));
    }

    public static enum CurrentType {
        EMPTY,
        FLUID,
        GAS,
        INFUSION,
        PIGMENT,
        SLURRY;

    }
}

